/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.id;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.doma.internal.jdbc.util.JdbcUtil;
import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.jdbc.JdbcLogger;
import org.seasar.doma.jdbc.Sql;
import org.seasar.doma.jdbc.id.IdGenerationConfig;
import org.seasar.doma.jdbc.id.IdGenerator;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public abstract class AbstractIdGenerator
implements IdGenerator {
    /*
     * Loose catch block
     */
    protected long getGeneratedValue(IdGenerationConfig config, Sql<?> sql) {
        JdbcLogger logger = config.getJdbcLogger();
        Connection connection = JdbcUtil.getConnection(config.getDataSource());
        try {
            PreparedStatement preparedStatement = JdbcUtil.prepareStatement(connection, sql);
            try {
                logger.logSql(this.getClass().getName(), "getGeneratedId", sql);
                this.setupOptions(config, preparedStatement);
                ResultSet resultSet = preparedStatement.executeQuery();
                long l = this.getGeneratedValue(config, resultSet);
                return l;
            }
            catch (SQLException e) {
                throw new JdbcException((MessageResource)Message.DOMA2018, (Throwable)e, config.getEntityType().getName(), e);
            }
            finally {
                JdbcUtil.close(preparedStatement, logger);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            JdbcUtil.close(connection, logger);
        }
    }

    protected void setupOptions(IdGenerationConfig config, PreparedStatement preparedStatement) throws SQLException {
        if (config.getFetchSize() > 0) {
            preparedStatement.setFetchSize(config.getFetchSize());
        }
        if (config.getMaxRows() > 0) {
            preparedStatement.setMaxRows(config.getMaxRows());
        }
        if (config.getQueryTimeout() > 0) {
            preparedStatement.setQueryTimeout(config.getQueryTimeout());
        }
    }

    protected long getGeneratedValue(IdGenerationConfig config, ResultSet resultSet) {
        JdbcLogger logger = config.getJdbcLogger();
        try {
            if (resultSet.next()) {
                long l = resultSet.getLong(1);
                return l;
            }
            try {
                throw new JdbcException((MessageResource)Message.DOMA2017, config.getEntityType().getName());
            }
            catch (SQLException e) {
                throw new JdbcException((MessageResource)Message.DOMA2018, (Throwable)e, config.getEntityType().getName(), e);
            }
        }
        finally {
            JdbcUtil.close(resultSet, logger);
        }
    }
}

