/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.domain;

import java.lang.reflect.Method;
import org.seasar.doma.DomaIllegalArgumentException;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.Domain;
import org.seasar.doma.EnumDomain;
import org.seasar.doma.internal.WrapException;
import org.seasar.doma.internal.jdbc.util.MetaTypeUtil;
import org.seasar.doma.internal.util.ClassUtil;
import org.seasar.doma.internal.util.MethodUtil;
import org.seasar.doma.jdbc.domain.DomainType;
import org.seasar.doma.jdbc.domain.DomainTypeNotFoundException;
import org.seasar.doma.message.Message;

public final class DomainTypeFactory {
    public static <V, D> DomainType<V, D> getDomainType(Class<D> domainClass) {
        if (domainClass == null) {
            throw new DomaNullPointerException("domainClass");
        }
        if (!domainClass.isAnnotationPresent(Domain.class) && !domainClass.isAnnotationPresent(EnumDomain.class)) {
            throw new DomaIllegalArgumentException("domainClass", Message.DOMA2205.getMessage(domainClass.getName()));
        }
        String domainTypeClassName = MetaTypeUtil.getMetaTypeName(domainClass.getName());
        try {
            Class clazz = ClassUtil.forName(domainTypeClassName);
            Method method = ClassUtil.getMethod(clazz, "getSingletonInternal", new Class[0]);
            return (DomainType)MethodUtil.invoke(method, null, new Object[0]);
        }
        catch (WrapException e) {
            throw new DomainTypeNotFoundException(e.getCause(), domainClass.getName(), domainTypeClassName);
        }
    }
}

