/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc;

import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.jdbc.Sql;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class UniqueConstraintException
extends JdbcException {
    private static final long serialVersionUID = 1L;
    protected final SqlKind kind;
    protected final String rawSql;
    protected final String formattedSql;
    protected final String sqlFilePath;

    public UniqueConstraintException(Sql<?> sql, Throwable cause) {
        this(sql.getKind(), sql.getRawSql(), sql.getFormattedSql(), sql.getSqlFilePath(), cause);
    }

    public UniqueConstraintException(SqlKind kind, String rawSql, String formattedSql, String sqlFilePath, Throwable cause) {
        super((MessageResource)Message.DOMA2004, sqlFilePath, formattedSql, cause);
        this.kind = kind;
        this.rawSql = rawSql;
        this.formattedSql = formattedSql;
        this.sqlFilePath = sqlFilePath;
    }

    protected UniqueConstraintException(MessageResource messageCode, SqlKind kind, String rawSql, String sqlFilePath, Throwable cause) {
        super(messageCode, cause, sqlFilePath, rawSql, cause);
        this.kind = kind;
        this.rawSql = rawSql;
        this.formattedSql = null;
        this.sqlFilePath = sqlFilePath;
    }

    public SqlKind getKind() {
        return this.kind;
    }

    public String getRawSql() {
        return this.rawSql;
    }

    public String getFormattedSql() {
        return this.formattedSql;
    }

    public String getSqlFilePath() {
        return this.sqlFilePath;
    }
}

