/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.wrapper;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Time;
import java.sql.Timestamp;
import org.seasar.doma.Domain;
import org.seasar.doma.EnumDomain;
import org.seasar.doma.internal.WrapException;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.internal.util.ClassUtil;
import org.seasar.doma.internal.util.MethodUtil;
import org.seasar.doma.internal.wrapper.WrapperException;
import org.seasar.doma.message.Message;
import org.seasar.doma.wrapper.ArrayWrapper;
import org.seasar.doma.wrapper.BigDecimalWrapper;
import org.seasar.doma.wrapper.BigIntegerWrapper;
import org.seasar.doma.wrapper.BlobWrapper;
import org.seasar.doma.wrapper.BooleanWrapper;
import org.seasar.doma.wrapper.ByteWrapper;
import org.seasar.doma.wrapper.BytesWrapper;
import org.seasar.doma.wrapper.ClobWrapper;
import org.seasar.doma.wrapper.DateWrapper;
import org.seasar.doma.wrapper.DoubleWrapper;
import org.seasar.doma.wrapper.EnumWrapper;
import org.seasar.doma.wrapper.FloatWrapper;
import org.seasar.doma.wrapper.IntegerWrapper;
import org.seasar.doma.wrapper.LongWrapper;
import org.seasar.doma.wrapper.NClobWrapper;
import org.seasar.doma.wrapper.ShortWrapper;
import org.seasar.doma.wrapper.StringWrapper;
import org.seasar.doma.wrapper.TimeWrapper;
import org.seasar.doma.wrapper.TimestampWrapper;
import org.seasar.doma.wrapper.UtilDateWrapper;
import org.seasar.doma.wrapper.Wrapper;

public final class Wrappers {
    public static Wrapper<?> wrap(Object value, Class<?> valueClass) {
        AssertionUtil.assertNotNull(valueClass);
        AssertionUtil.assertTrue(value == null || ClassUtil.toBoxedPrimitiveTypeIfPossible(valueClass).isInstance(value), new Object[0]);
        if (Wrapper.class.isAssignableFrom(valueClass)) {
            return (Wrapper)value;
        }
        Wrapper<?> result = Wrappers.wrapBasicObject(value, valueClass);
        if (result == null && (result = Wrappers.wrapDomainObject(value, valueClass)) == null && (result = Wrappers.wrapEnumObject(value, valueClass)) == null) {
            throw new WrapperException(Message.DOMA1007, valueClass.getName(), value);
        }
        return result;
    }

    protected static Wrapper<?> wrapBasicObject(Object value, Class<?> valueClass) {
        AssertionUtil.assertNotNull(valueClass);
        Class<?> boxedClass = ClassUtil.toBoxedPrimitiveTypeIfPossible(valueClass);
        if (boxedClass == String.class) {
            return new StringWrapper((String)value);
        }
        if (boxedClass == Integer.class) {
            return new IntegerWrapper((Integer)value);
        }
        if (boxedClass == Long.class) {
            return new LongWrapper((Long)value);
        }
        if (boxedClass == BigDecimal.class) {
            return new BigDecimalWrapper((BigDecimal)value);
        }
        if (boxedClass == java.util.Date.class) {
            return new UtilDateWrapper((java.util.Date)value);
        }
        if (boxedClass == Date.class) {
            return new DateWrapper((Date)value);
        }
        if (boxedClass == Timestamp.class) {
            return new TimestampWrapper((Timestamp)value);
        }
        if (boxedClass == Time.class) {
            return new TimeWrapper((Time)value);
        }
        if (boxedClass == Boolean.class) {
            return new BooleanWrapper((Boolean)value);
        }
        if (boxedClass == Array.class) {
            return new ArrayWrapper((Array)value);
        }
        if (boxedClass == BigInteger.class) {
            return new BigIntegerWrapper((BigInteger)value);
        }
        if (boxedClass == Blob.class) {
            return new BlobWrapper((Blob)value);
        }
        if (boxedClass == byte[].class) {
            return new BytesWrapper((byte[])value);
        }
        if (boxedClass == Byte.class) {
            return new ByteWrapper((Byte)value);
        }
        if (boxedClass == Clob.class) {
            return new ClobWrapper((Clob)value);
        }
        if (boxedClass == Double.class) {
            return new DoubleWrapper((Double)value);
        }
        if (boxedClass == Float.class) {
            return new FloatWrapper((Float)value);
        }
        if (boxedClass == NClob.class) {
            return new NClobWrapper((NClob)value);
        }
        if (boxedClass == Short.class) {
            return new ShortWrapper((Short)value);
        }
        return null;
    }

    protected static Wrapper<?> wrapEnumObject(Object value, Class<?> valueClass) {
        AssertionUtil.assertNotNull(valueClass);
        Class<?> boxedClass = ClassUtil.toBoxedPrimitiveTypeIfPossible(valueClass);
        if (boxedClass.isEnum() || Enum.class.isAssignableFrom(boxedClass)) {
            return new EnumWrapper<Enum>(boxedClass, (Enum)value);
        }
        return null;
    }

    protected static Wrapper<?> wrapDomainObject(Object value, Class<?> valueClass) {
        Wrapper<?> result;
        AssertionUtil.assertNotNull(valueClass);
        DomainDesc domainDesc = Wrappers.getDomainDesc(valueClass);
        if (domainDesc == null) {
            return null;
        }
        Object domainValue = null;
        if (value != null) {
            domainValue = Wrappers.getDomainValue(value, valueClass, domainDesc.accessorMethod);
        }
        if ((result = Wrappers.wrapBasicObject(domainValue, domainDesc.valueType)) == null) {
            result = Wrappers.wrapEnumObject(domainValue, domainDesc.valueType);
        }
        return result;
    }

    protected static DomainDesc getDomainDesc(Class<?> clazz) {
        AssertionUtil.assertNotNull(clazz);
        Domain domain = clazz.getAnnotation(Domain.class);
        if (domain != null) {
            return new DomainDesc(domain.valueType(), domain.accessorMethod());
        }
        EnumDomain enumDomain = clazz.getAnnotation(EnumDomain.class);
        if (enumDomain != null) {
            return new DomainDesc(enumDomain.valueType(), enumDomain.accessorMethod());
        }
        return null;
    }

    protected static Object getDomainValue(Object domainObject, Class<?> domainClass, String accessorMethodName) {
        AssertionUtil.assertNotNull(domainObject, domainClass, (Object)accessorMethodName);
        try {
            Method method = Wrappers.findAccessorMethod(domainClass, accessorMethodName);
            if (!Modifier.isPublic(method.getModifiers())) {
                method.setAccessible(true);
            }
            method.setAccessible(true);
            return MethodUtil.invoke(method, domainObject, new Object[0]);
        }
        catch (WrapException e) {
            Throwable cause = e.getCause();
            throw new WrapperException(Message.DOMA1006, cause, new Object[]{cause});
        }
    }

    protected static Method findAccessorMethod(Class<?> domainClass, String accessorMethodName) {
        AssertionUtil.assertNotNull(domainClass, (Object)accessorMethodName);
        for (Class<?> clazz = domainClass; clazz != null; clazz = clazz.getSuperclass()) {
            for (Method m : clazz.getDeclaredMethods()) {
                if (!accessorMethodName.equals(m.getName()) || m.getParameterTypes().length != 0) continue;
                return m;
            }
        }
        return (Method)AssertionUtil.assertUnreachable();
    }

    private static class DomainDesc {
        private final Class<?> valueType;
        private final String accessorMethod;

        private DomainDesc(Class<?> valueType, String accessorMethod) {
            AssertionUtil.assertNotNull(valueType, (Object)accessorMethod);
            this.valueType = valueType;
            this.accessorMethod = accessorMethod;
        }
    }
}

