/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.sql;

import org.seasar.doma.internal.jdbc.sql.CallableSqlParameterVisitor;
import org.seasar.doma.internal.jdbc.sql.ResultParameter;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.domain.DomainType;
import org.seasar.doma.jdbc.domain.DomainWrapper;
import org.seasar.doma.wrapper.Wrapper;

public class DomainResultParameter<V, D>
implements ResultParameter<D> {
    protected final DomainType<V, D> domainType;
    protected final DomainWrapper<V, D> wrapper;

    public DomainResultParameter(DomainType<V, D> domainType) {
        AssertionUtil.assertNotNull(domainType);
        this.domainType = domainType;
        this.wrapper = domainType.getWrapper(null);
    }

    public Wrapper<V> getWrapper() {
        return this.wrapper;
    }

    @Override
    public Object getValue() {
        return this.wrapper.getDomain();
    }

    @Override
    public D getResult() {
        return this.wrapper.getDomain();
    }

    @Override
    public <R, P, TH extends Throwable> R accept(CallableSqlParameterVisitor<R, P, TH> visitor, P p) throws TH {
        return visitor.visitDomainResultParameter(this, p);
    }
}

