/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.sql;

import org.seasar.doma.internal.jdbc.sql.CallableSqlParameterVisitor;
import org.seasar.doma.internal.jdbc.sql.InParameter;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.domain.DomainType;
import org.seasar.doma.wrapper.Wrapper;

public class DomainInParameter<V, D>
implements InParameter {
    protected final DomainType<V, D> domainType;
    protected final D domain;

    public DomainInParameter(DomainType<V, D> domainType, D domain) {
        AssertionUtil.assertNotNull(domainType, domain);
        this.domainType = domainType;
        this.domain = domain;
    }

    @Override
    public Object getValue() {
        return this.domain;
    }

    @Override
    public Wrapper<?> getWrapper() {
        return this.domainType.getWrapper(this.domain);
    }

    @Override
    public <R, P, TH extends Throwable> R accept(CallableSqlParameterVisitor<R, P, TH> visitor, P p) throws TH {
        return visitor.visitDomainInParameter(this, p);
    }
}

