/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.query;

import java.net.URL;
import org.seasar.doma.internal.jdbc.query.ScriptQuery;
import org.seasar.doma.internal.jdbc.util.ScriptFileUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.internal.util.ResourceUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.ScriptFileNotFoundException;
import org.seasar.doma.jdbc.Sql;

public class SqlFileScriptQuery
implements ScriptQuery {
    protected Config config;
    protected String scriptFilePath;
    protected String callerClassName;
    protected String callerMethodName;
    protected String blockDelimiter;
    protected boolean haltOnError;
    protected URL scriptFileUrl;

    public void setConfig(Config config) {
        this.config = config;
    }

    public void setScriptFilePath(String scriptFilePath) {
        this.scriptFilePath = scriptFilePath;
    }

    public void setCallerClassName(String callerClassName) {
        this.callerClassName = callerClassName;
    }

    public void setCallerMethodName(String callerMethodName) {
        this.callerMethodName = callerMethodName;
    }

    public void setBlockDelimiter(String blockDelimiter) {
        this.blockDelimiter = blockDelimiter;
    }

    public void setHaltOnError(boolean haltOnError) {
        this.haltOnError = haltOnError;
    }

    @Override
    public void prepare() {
        AssertionUtil.assertNotNull((Object)this.config, (Object)this.scriptFilePath, (Object)this.callerClassName, (Object)this.callerMethodName, (Object)this.blockDelimiter);
        AssertionUtil.assertTrue(this.scriptFilePath.startsWith("META-INF/"), new Object[0]);
        AssertionUtil.assertTrue(this.scriptFilePath.endsWith(".script"), new Object[0]);
        String dbmsSpecificPath = ScriptFileUtil.convertToDbmsSpecificPath(this.scriptFilePath, this.config.getDialect());
        this.scriptFileUrl = ResourceUtil.getResource(dbmsSpecificPath);
        if (this.scriptFileUrl != null) {
            this.scriptFilePath = dbmsSpecificPath;
        } else {
            this.scriptFileUrl = ResourceUtil.getResource(this.scriptFilePath);
            if (this.scriptFileUrl == null) {
                throw new ScriptFileNotFoundException(this.scriptFilePath);
            }
        }
        if (this.blockDelimiter.isEmpty()) {
            this.blockDelimiter = this.config.getDialect().getScriptBlockDelimiter();
        }
    }

    @Override
    public void complete() {
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public String getClassName() {
        return this.callerClassName;
    }

    @Override
    public String getMethodName() {
        return this.callerMethodName;
    }

    @Override
    public int getQueryTimeout() {
        return -1;
    }

    @Override
    public Sql<?> getSql() {
        AssertionUtil.assertUnreachable();
        return null;
    }

    @Override
    public String getScriptFilePath() {
        return this.scriptFilePath;
    }

    @Override
    public URL getScriptFileUrl() {
        return this.scriptFileUrl;
    }

    @Override
    public String getBlockDelimiter() {
        return this.blockDelimiter;
    }

    @Override
    public boolean getHaltOnError() {
        return this.haltOnError;
    }
}

