/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.query;

import org.seasar.doma.internal.jdbc.entity.AbstractPostDeleteContext;
import org.seasar.doma.internal.jdbc.entity.AbstractPreDeleteContext;
import org.seasar.doma.internal.jdbc.query.DeleteQuery;
import org.seasar.doma.internal.jdbc.query.SqlFileModifyQuery;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.entity.VersionPropertyType;

public class SqlFileDeleteQuery
extends SqlFileModifyQuery
implements DeleteQuery {
    protected EntityHandler<?> entityHandler;
    protected boolean versionIgnored;
    protected boolean optimisticLockExceptionSuppressed;

    public SqlFileDeleteQuery() {
        super(SqlKind.DELETE);
    }

    @Override
    public void prepare() {
        AssertionUtil.assertNotNull((Object)this.config, (Object)this.sqlFilePath, (Object)this.callerClassName, (Object)this.callerMethodName);
        this.preDelete();
        this.prepareOptions();
        this.prepareOptimisticLock();
        this.prepareSql();
        AssertionUtil.assertNotNull(this.sql);
    }

    protected void preDelete() {
        if (this.entityHandler != null) {
            this.entityHandler.preDelete();
        }
    }

    protected void prepareOptimisticLock() {
        if (this.entityHandler != null) {
            this.entityHandler.prepareOptimisticLock();
        }
    }

    @Override
    public void complete() {
        if (this.entityHandler != null) {
            this.entityHandler.postDelete();
        }
    }

    @Override
    public <E> void setEntityAndEntityType(E entity, EntityType<E> entityType) {
        this.entityHandler = new EntityHandler<E>(entity, entityType);
    }

    public void setVersionIgnored(boolean versionIgnored) {
        this.versionIgnored = versionIgnored;
    }

    public void setOptimisticLockExceptionSuppressed(boolean optimisticLockExceptionSuppressed) {
        this.optimisticLockExceptionSuppressed = optimisticLockExceptionSuppressed;
    }

    protected static class SqlFilePostDeleteContext
    extends AbstractPostDeleteContext {
        public SqlFilePostDeleteContext(EntityType<?> entityType) {
            super(entityType);
        }
    }

    protected static class SqlFilePreDeleteContext
    extends AbstractPreDeleteContext {
        public SqlFilePreDeleteContext(EntityType<?> entityType) {
            super(entityType);
        }
    }

    protected class EntityHandler<E> {
        protected E entity;
        protected EntityType<E> entityType;
        protected VersionPropertyType<? super E, E, ?, ?> versionPropertyType;

        protected EntityHandler(E entity, EntityType<E> entityType) {
            AssertionUtil.assertNotNull(entity, entityType);
            this.entity = entity;
            this.entityType = entityType;
            this.versionPropertyType = entityType.getVersionPropertyType();
        }

        protected void preDelete() {
            SqlFilePreDeleteContext context = new SqlFilePreDeleteContext(this.entityType);
            this.entityType.preDelete(this.entity, context);
        }

        protected void postDelete() {
            SqlFilePostDeleteContext context = new SqlFilePostDeleteContext(this.entityType);
            this.entityType.postDelete(this.entity, context);
        }

        protected void prepareOptimisticLock() {
            if (this.versionPropertyType != null && !SqlFileDeleteQuery.this.versionIgnored && !SqlFileDeleteQuery.this.optimisticLockExceptionSuppressed) {
                SqlFileDeleteQuery.this.optimisticLockCheckRequired = true;
            }
        }
    }
}

