/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.query;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.seasar.doma.internal.jdbc.entity.AbstractPostUpdateContext;
import org.seasar.doma.internal.jdbc.entity.AbstractPreUpdateContext;
import org.seasar.doma.internal.jdbc.query.AutoModifyQuery;
import org.seasar.doma.internal.jdbc.query.UpdateQuery;
import org.seasar.doma.internal.jdbc.sql.PreparedSqlBuilder;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.entity.VersionPropertyType;
import org.seasar.doma.wrapper.Wrapper;

public class AutoUpdateQuery<E>
extends AutoModifyQuery<E>
implements UpdateQuery {
    protected boolean nullExcluded;
    protected boolean versionIgnored;
    protected boolean optimisticLockExceptionSuppressed;
    protected boolean unchangedPropertyIncluded;

    public AutoUpdateQuery(EntityType<E> entityType) {
        super(entityType);
    }

    @Override
    public void prepare() {
        AssertionUtil.assertNotNull((Object)this.config, (Object)this.entityType, this.entity, (Object)this.callerClassName, (Object)this.callerMethodName);
        this.preUpdate();
        this.prepareIdAndVersionPropertyTypes();
        this.validateIdExistent();
        this.prepareOptions();
        this.prepareOptimisticLock();
        this.prepareTargetPropertyTypes();
        this.prepareSql();
        AssertionUtil.assertNotNull(this.sql);
    }

    protected void preUpdate() {
        List<EntityPropertyType<E, ?>> targetPropertyTypes = this.getTargetPropertyTypes();
        AutoPreUpdateContext<E> context = new AutoPreUpdateContext<E>(this.entityType, targetPropertyTypes);
        this.entityType.preUpdate(this.entity, context);
    }

    protected void prepareOptimisticLock() {
        if (!this.versionIgnored && this.versionPropertyType != null && !this.optimisticLockExceptionSuppressed) {
            this.optimisticLockCheckRequired = true;
        }
    }

    protected void prepareTargetPropertyTypes() {
        this.targetPropertyTypes = this.getTargetPropertyTypes();
        if (!this.targetPropertyTypes.isEmpty()) {
            this.executable = true;
            this.sqlExecutionSkipCause = null;
        }
    }

    protected List<EntityPropertyType<E, ?>> getTargetPropertyTypes() {
        int capacity = this.entityType.getEntityPropertyTypes().size();
        ArrayList results = new ArrayList(capacity);
        Object originalStates = this.entityType.getOriginalStates(this.entity);
        for (EntityPropertyType<Object, ?> entityPropertyType : this.entityType.getEntityPropertyTypes()) {
            String name;
            if (!entityPropertyType.isUpdatable() || entityPropertyType.isId() || !this.versionIgnored && entityPropertyType.isVersion() || this.nullExcluded && entityPropertyType.getWrapper(this.entity).get() == null || !this.unchangedPropertyIncluded && originalStates != null && !this.isChanged(originalStates, entityPropertyType) || !this.isTargetPropertyName(name = entityPropertyType.getName())) continue;
            results.add(entityPropertyType);
        }
        return results;
    }

    protected boolean isChanged(E originalStates, EntityPropertyType<E, ?> propertyType) {
        EntityPropertyType<E, ?> originalPropertyType = this.entityType.getEntityPropertyType(propertyType.getName());
        if (originalPropertyType == null) {
            return true;
        }
        Wrapper<?> originalWrapper = originalPropertyType.getWrapper(originalStates);
        Wrapper<?> wrapper = propertyType.getWrapper(this.entity);
        return !wrapper.hasEqualValue(originalWrapper.get());
    }

    protected void prepareSql() {
        PreparedSqlBuilder builder = new PreparedSqlBuilder(this.config, SqlKind.UPDATE);
        builder.appendSql("update ");
        builder.appendSql(this.entityType.getQualifiedTableName());
        builder.appendSql(" set ");
        for (EntityPropertyType p : this.targetPropertyTypes) {
            builder.appendSql(p.getColumnName());
            builder.appendSql(" = ");
            builder.appendWrapper(p.getWrapper(this.entity));
            builder.appendSql(", ");
        }
        if (!this.versionIgnored && this.versionPropertyType != null) {
            builder.appendSql(this.versionPropertyType.getColumnName());
            builder.appendSql(" = ");
            builder.appendWrapper(this.versionPropertyType.getWrapper(this.entity));
            builder.appendSql(" + 1");
        } else {
            builder.cutBackSql(2);
        }
        if (this.idPropertyTypes.size() > 0) {
            builder.appendSql(" where ");
            for (EntityPropertyType p : this.idPropertyTypes) {
                builder.appendSql(p.getColumnName());
                builder.appendSql(" = ");
                builder.appendWrapper(p.getWrapper(this.entity));
                builder.appendSql(" and ");
            }
            builder.cutBackSql(5);
        }
        if (!this.versionIgnored && this.versionPropertyType != null) {
            if (this.idPropertyTypes.size() == 0) {
                builder.appendSql(" where ");
            } else {
                builder.appendSql(" and ");
            }
            builder.appendSql(this.versionPropertyType.getColumnName());
            builder.appendSql(" = ");
            builder.appendWrapper(this.versionPropertyType.getWrapper(this.entity));
        }
        this.sql = builder.build();
    }

    @Override
    public void incrementVersion() {
        if (!this.versionIgnored && this.versionPropertyType != null) {
            this.versionPropertyType.increment(this.entity);
        }
    }

    @Override
    public void complete() {
        this.postUpdate();
    }

    protected void postUpdate() {
        List<EntityPropertyType<VersionPropertyType, ?>> targetPropertyTypes = this.getTargetPropertyTypes();
        if (!this.versionIgnored && this.versionPropertyType != null) {
            targetPropertyTypes.add(this.versionPropertyType);
        }
        AutoPostUpdateContext<E> context = new AutoPostUpdateContext<E>(this.entityType, targetPropertyTypes);
        this.entityType.postUpdate(this.entity, context);
    }

    public void setNullExcluded(boolean nullExcluded) {
        this.nullExcluded = nullExcluded;
    }

    public void setVersionIncluded(boolean versionIncluded) {
        this.versionIgnored |= versionIncluded;
    }

    public void setVersionIgnored(boolean versionIgnored) {
        this.versionIgnored |= versionIgnored;
    }

    public void setOptimisticLockExceptionSuppressed(boolean optimisticLockExceptionSuppressed) {
        this.optimisticLockExceptionSuppressed = optimisticLockExceptionSuppressed;
    }

    public void setUnchangedPropertyIncluded(Boolean unchangedPropertyIncluded) {
        this.unchangedPropertyIncluded = unchangedPropertyIncluded;
    }

    protected static class AutoPostUpdateContext<E>
    extends AbstractPostUpdateContext {
        protected final Set<String> changedPropertyNames;

        public AutoPostUpdateContext(EntityType<E> entityType, List<EntityPropertyType<E, ?>> targetPropertyTypes) {
            super(entityType);
            AssertionUtil.assertNotNull(targetPropertyTypes);
            this.changedPropertyNames = new HashSet<String>(targetPropertyTypes.size());
            for (EntityPropertyType<E, ?> propertyType : targetPropertyTypes) {
                this.changedPropertyNames.add(propertyType.getName());
            }
        }

        @Override
        public boolean isPropertyChanged(String propertyName) {
            this.validatePropertyDefined(propertyName);
            return this.changedPropertyNames.contains(propertyName);
        }
    }

    protected static class AutoPreUpdateContext<E>
    extends AbstractPreUpdateContext {
        protected final Set<String> changedPropertyNames;

        public AutoPreUpdateContext(EntityType<E> entityType, List<EntityPropertyType<E, ?>> targetPropertyTypes) {
            super(entityType);
            AssertionUtil.assertNotNull(targetPropertyTypes);
            this.changedPropertyNames = new HashSet<String>(targetPropertyTypes.size());
            for (EntityPropertyType<E, ?> propertyType : targetPropertyTypes) {
                this.changedPropertyNames.add(propertyType.getName());
            }
        }

        @Override
        public boolean isEntityChanged() {
            return !this.changedPropertyNames.isEmpty();
        }

        @Override
        public boolean isPropertyChanged(String propertyName) {
            this.validatePropertyDefined(propertyName);
            return this.changedPropertyNames.contains(propertyName);
        }
    }
}

