/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.dialect;

import org.seasar.doma.internal.jdbc.dialect.StandardForUpdateTransformer;
import org.seasar.doma.internal.jdbc.sql.node.FragmentNode;
import org.seasar.doma.internal.jdbc.sql.node.FromClauseNode;
import org.seasar.doma.internal.jdbc.sql.node.SelectStatementNode;
import org.seasar.doma.jdbc.SelectForUpdateType;
import org.seasar.doma.jdbc.SqlNode;

public class Mssql2008ForUpdateTransformer
extends StandardForUpdateTransformer {
    public Mssql2008ForUpdateTransformer(SelectForUpdateType forUpdateType, int waitSeconds, String ... aliases) {
        super(forUpdateType, waitSeconds, aliases);
    }

    @Override
    public SqlNode visitSelectStatementNode(SelectStatementNode node, Void p) {
        if (this.processed) {
            return node;
        }
        this.processed = true;
        StringBuilder buf = new StringBuilder(100).append("with (updlock, rowlock");
        if (this.forUpdateType == SelectForUpdateType.NOWAIT) {
            buf.append(", nowait");
        }
        buf.append(") ");
        FromClauseNode originalFrom = node.getFromClauseNode();
        FromClauseNode from = new FromClauseNode(originalFrom.getWordNode());
        for (SqlNode child : originalFrom.getChildren()) {
            from.addNode(child);
        }
        from.addNode(new FragmentNode(buf.toString()));
        SelectStatementNode result = new SelectStatementNode();
        result.setSelectClauseNode(node.getSelectClauseNode());
        result.setFromClauseNode(from);
        result.setWhereClauseNode(node.getWhereClauseNode());
        result.setGroupByClauseNode(node.getGroupByClauseNode());
        result.setHavingClauseNode(node.getHavingClauseNode());
        result.setOrderByClauseNode(node.getOrderByClauseNode());
        return result;
    }
}

