/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.doma.internal.jdbc.command.Command;
import org.seasar.doma.internal.jdbc.command.PreparedSqlParameterBinder;
import org.seasar.doma.internal.jdbc.command.ResultSetHandler;
import org.seasar.doma.internal.jdbc.query.SelectQuery;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.internal.jdbc.util.JdbcUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.JdbcLogger;
import org.seasar.doma.jdbc.SqlExecutionException;
import org.seasar.doma.jdbc.dialect.Dialect;

public class SelectCommand<R>
implements Command<R, SelectQuery> {
    protected final SelectQuery query;
    protected final PreparedSql sql;
    protected final ResultSetHandler<R> resultSetHandler;

    public SelectCommand(SelectQuery query, ResultSetHandler<R> resultSetHandler) {
        AssertionUtil.assertNotNull((Object)query, resultSetHandler);
        this.query = query;
        this.sql = query.getSql();
        this.resultSetHandler = resultSetHandler;
    }

    /*
     * Loose catch block
     */
    @Override
    public R execute() {
        Connection connection = JdbcUtil.getConnection(this.query.getConfig().getDataSource());
        try {
            R r;
            PreparedStatement preparedStatement = JdbcUtil.prepareStatement(connection, this.sql);
            try {
                this.log();
                this.setupOptions(preparedStatement);
                this.bindParameters(preparedStatement);
                r = this.executeQuery(preparedStatement);
            }
            catch (SQLException e) {
                Dialect dialect = this.query.getConfig().getDialect();
                throw new SqlExecutionException(this.sql, (Throwable)e, dialect.getRootCause(e));
            }
            finally {
                JdbcUtil.close(preparedStatement, this.query.getConfig().getJdbcLogger());
            }
            return r;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            JdbcUtil.close(connection, this.query.getConfig().getJdbcLogger());
        }
    }

    protected void log() {
        JdbcLogger logger = this.query.getConfig().getJdbcLogger();
        logger.logSql(this.query.getClassName(), this.query.getMethodName(), this.sql);
    }

    protected void setupOptions(PreparedStatement preparedStatement) throws SQLException {
        if (this.query.getFetchSize() > 0) {
            preparedStatement.setFetchSize(this.query.getFetchSize());
        }
        if (this.query.getMaxRows() > 0) {
            preparedStatement.setMaxRows(this.query.getMaxRows());
        }
        if (this.query.getQueryTimeout() > 0) {
            preparedStatement.setQueryTimeout(this.query.getQueryTimeout());
        }
    }

    protected void bindParameters(PreparedStatement preparedStatement) throws SQLException {
        PreparedSqlParameterBinder binder = new PreparedSqlParameterBinder(this.query);
        binder.bind(preparedStatement, this.sql.getParameters());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected R executeQuery(PreparedStatement preparedStatement) throws SQLException {
        ResultSet resultSet = preparedStatement.executeQuery();
        try {
            R r = this.resultSetHandler.handle(resultSet, this.query);
            return r;
        }
        finally {
            JdbcUtil.close(resultSet, this.query.getConfig().getJdbcLogger());
        }
    }
}

