/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.doma.internal.jdbc.command.EntityFetcher;
import org.seasar.doma.internal.jdbc.command.ResultSetHandler;
import org.seasar.doma.internal.jdbc.query.SelectQuery;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.NoResultException;
import org.seasar.doma.jdbc.NonUniqueResultException;
import org.seasar.doma.jdbc.entity.EntityType;

public class EntitySingleResultHandler<E>
implements ResultSetHandler<E> {
    protected final EntityType<E> entityType;

    public EntitySingleResultHandler(EntityType<E> entityType) {
        AssertionUtil.assertNotNull(entityType);
        this.entityType = entityType;
    }

    @Override
    public E handle(ResultSet resultSet, SelectQuery query) throws SQLException {
        EntityFetcher<E> fetcher = new EntityFetcher<E>(query, this.entityType);
        if (resultSet.next()) {
            E entity = this.entityType.newEntity();
            fetcher.fetch(resultSet, entity);
            if (resultSet.next()) {
                PreparedSql sql = query.getSql();
                throw new NonUniqueResultException(sql);
            }
            return entity;
        }
        if (query.isResultEnsured()) {
            PreparedSql sql = query.getSql();
            throw new NoResultException(sql);
        }
        return null;
    }
}

