/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.seasar.doma.internal.jdbc.command.EntityFetcher;
import org.seasar.doma.internal.jdbc.command.ResultSetHandler;
import org.seasar.doma.internal.jdbc.query.SelectQuery;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.NoResultException;
import org.seasar.doma.jdbc.entity.EntityType;

public class EntityResultListHandler<E>
implements ResultSetHandler<List<E>> {
    protected final EntityType<E> entityType;

    public EntityResultListHandler(EntityType<E> entityType) {
        AssertionUtil.assertNotNull(entityType);
        this.entityType = entityType;
    }

    @Override
    public List<E> handle(ResultSet resultSet, SelectQuery query) throws SQLException {
        EntityFetcher<E> fetcher = new EntityFetcher<E>(query, this.entityType);
        ArrayList<E> entities = new ArrayList<E>();
        while (resultSet.next()) {
            E entity = this.entityType.newEntity();
            fetcher.fetch(resultSet, entity);
            entities.add(entity);
        }
        if (query.isResultEnsured() && entities.isEmpty()) {
            PreparedSql sql = query.getSql();
            throw new NoResultException(sql);
        }
        return entities;
    }
}

