/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.seasar.doma.internal.jdbc.command.Command;
import org.seasar.doma.internal.jdbc.command.PreparedSqlParameterBinder;
import org.seasar.doma.internal.jdbc.query.BatchModifyQuery;
import org.seasar.doma.internal.jdbc.query.Query;
import org.seasar.doma.internal.jdbc.sql.PreparedSql;
import org.seasar.doma.internal.jdbc.util.JdbcUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.BatchOptimisticLockException;
import org.seasar.doma.jdbc.BatchSqlExecutionException;
import org.seasar.doma.jdbc.BatchUniqueConstraintException;
import org.seasar.doma.jdbc.JdbcLogger;
import org.seasar.doma.jdbc.dialect.Dialect;

public abstract class BatchModifyCommand<Q extends BatchModifyQuery>
implements Command<int[], Q> {
    protected final Q query;

    protected BatchModifyCommand(Q query) {
        AssertionUtil.assertNotNull(query);
        this.query = query;
    }

    /*
     * Loose catch block
     */
    @Override
    public int[] execute() {
        if (!this.query.isExecutable()) {
            JdbcLogger logger = this.query.getConfig().getJdbcLogger();
            logger.logSqlExecutionSkipping(this.query.getClassName(), this.query.getMethodName(), this.query.getSqlExecutionSkipCause());
            return new int[0];
        }
        Connection connection = JdbcUtil.getConnection(this.query.getConfig().getDataSource());
        try {
            PreparedSql sql = this.query.getSql();
            PreparedStatement preparedStatement = this.prepareStatement(connection, sql);
            try {
                this.setupOptions(preparedStatement);
                int[] nArray = this.executeInternal(preparedStatement, this.query.getSqls());
                return nArray;
            }
            catch (SQLException e) {
                Dialect dialect = this.query.getConfig().getDialect();
                throw new BatchSqlExecutionException(sql, (Throwable)e, dialect.getRootCause(e));
            }
            finally {
                JdbcUtil.close(preparedStatement, this.query.getConfig().getJdbcLogger());
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            JdbcUtil.close(connection, this.query.getConfig().getJdbcLogger());
        }
    }

    protected PreparedStatement prepareStatement(Connection connection, PreparedSql sql) {
        if (this.query.isAutoGeneratedKeysSupported()) {
            return JdbcUtil.prepareStatementForAutoGeneratedKeys(connection, sql);
        }
        return JdbcUtil.prepareStatement(connection, sql);
    }

    protected abstract int[] executeInternal(PreparedStatement var1, List<PreparedSql> var2) throws SQLException;

    protected void setupOptions(PreparedStatement preparedStatement) throws SQLException {
        if (this.query.getQueryTimeout() > 0) {
            preparedStatement.setQueryTimeout(this.query.getQueryTimeout());
        }
    }

    protected int[] executeBatch(PreparedStatement preparedStatement, List<PreparedSql> sqls) throws SQLException {
        int batchSize = this.query.getBatchSize() > 0 ? this.query.getBatchSize() : 1;
        int sqlSize = sqls.size();
        int[] updatedRows = new int[sqlSize];
        int pos = 0;
        for (int i = 0; i < sqlSize; ++i) {
            PreparedSql sql = sqls.get(i);
            this.log(sql);
            this.bindParameters(preparedStatement, sql);
            preparedStatement.addBatch();
            if (i != sqlSize - 1 && (batchSize <= 0 || (i + 1) % batchSize != 0)) continue;
            int[] rows = this.executeBatch(preparedStatement, sql);
            this.validateRows(preparedStatement, sql, rows);
            System.arraycopy(rows, 0, updatedRows, pos, rows.length);
            pos = i + 1;
        }
        return updatedRows;
    }

    protected int[] executeBatch(PreparedStatement preparedStatement, PreparedSql sql) throws SQLException {
        try {
            return preparedStatement.executeBatch();
        }
        catch (SQLException e) {
            Dialect dialect = this.query.getConfig().getDialect();
            if (dialect.isUniqueConstraintViolated(e)) {
                throw new BatchUniqueConstraintException(sql, (Throwable)e);
            }
            throw e;
        }
    }

    protected void log(PreparedSql sql) {
        JdbcLogger logger = this.query.getConfig().getJdbcLogger();
        logger.logSql(this.query.getClassName(), this.query.getMethodName(), sql);
    }

    protected void bindParameters(PreparedStatement preparedStatement, PreparedSql sql) throws SQLException {
        PreparedSqlParameterBinder binder = new PreparedSqlParameterBinder((Query)this.query);
        binder.bind(preparedStatement, sql.getParameters());
    }

    protected void validateRows(PreparedStatement preparedStatement, PreparedSql sql, int[] rows) throws SQLException {
        Dialect dialect = this.query.getConfig().getDialect();
        if (dialect.supportsBatchUpdateResults()) {
            if (!this.query.isOptimisticLockCheckRequired()) {
                return;
            }
            for (int i = 0; i < rows.length; ++i) {
                if (rows[i] == 1) continue;
                throw new BatchOptimisticLockException(sql);
            }
        } else if (preparedStatement.getUpdateCount() == rows.length) {
            Arrays.fill(rows, 1);
        } else {
            if (!this.query.isOptimisticLockCheckRequired()) {
                return;
            }
            throw new BatchOptimisticLockException(sql);
        }
    }
}

