/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.type;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.Entity;
import org.seasar.doma.internal.apt.type.AbstractDataType;
import org.seasar.doma.internal.apt.type.DataTypeVisitor;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public class EntityType
extends AbstractDataType {
    public EntityType(TypeMirror type, ProcessingEnvironment env) {
        super(type, env);
    }

    public static EntityType newInstance(TypeMirror type, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull((Object)type, (Object)env);
        TypeElement typeElement = TypeMirrorUtil.toTypeElement(type, env);
        if (typeElement == null || typeElement.getAnnotation(Entity.class) == null) {
            return null;
        }
        return new EntityType(type, env);
    }

    public boolean isAbstract() {
        return this.typeElement.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    @Override
    public <R, P, TH extends Throwable> R accept(DataTypeVisitor<R, P, TH> visitor, P p) throws TH {
        return visitor.visitEntityType(this, p);
    }
}

