/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.type;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.type.DataType;
import org.seasar.doma.internal.apt.util.ElementUtil;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public abstract class AbstractDataType
implements DataType {
    protected final TypeMirror typeMirror;
    protected final ProcessingEnvironment env;
    protected final String typeName;
    protected final String typeNameAsTypeParameter;
    protected final TypeElement typeElement;
    protected final String packageName;
    protected final String packageExcludedBinaryName;
    protected String qualifiedName;

    protected AbstractDataType(TypeMirror typeMirror, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull((Object)typeMirror, (Object)env);
        this.typeMirror = typeMirror;
        this.env = env;
        this.typeName = TypeMirrorUtil.getTypeName(typeMirror, env);
        this.typeElement = TypeMirrorUtil.toTypeElement(typeMirror, env);
        if (this.typeElement != null) {
            this.qualifiedName = this.typeElement.getQualifiedName().toString();
            this.packageName = ElementUtil.getPackageName(this.typeElement, env);
            this.packageExcludedBinaryName = ElementUtil.getPackageExcludedBinaryName(this.typeElement, env);
        } else {
            this.qualifiedName = this.typeName;
            this.packageName = "";
            this.packageExcludedBinaryName = this.typeName;
        }
        if (typeMirror.getKind().isPrimitive()) {
            Class<?> boxedClass = this.getBoxedClass(typeMirror);
            this.typeNameAsTypeParameter = boxedClass.getName();
        } else {
            this.typeNameAsTypeParameter = this.typeName;
        }
    }

    @Override
    public TypeMirror getTypeMirror() {
        return this.typeMirror;
    }

    @Override
    public TypeElement getTypeElement() {
        return this.typeElement;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public String getTypeNameAsTypeParameter() {
        return this.typeNameAsTypeParameter;
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public String getPackageExcludedBinaryName() {
        return this.packageExcludedBinaryName;
    }

    @Override
    public boolean isEnum() {
        return this.typeElement != null && this.typeElement.getKind() == ElementKind.ENUM;
    }

    @Override
    public boolean isPrimitive() {
        return this.typeMirror.getKind().isPrimitive();
    }

    protected Class<?> getBoxedClass(TypeMirror typeMirror) {
        switch (typeMirror.getKind()) {
            case BOOLEAN: {
                return Boolean.class;
            }
            case BYTE: {
                return Byte.class;
            }
            case SHORT: {
                return Short.class;
            }
            case INT: {
                return Integer.class;
            }
            case LONG: {
                return Long.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case DOUBLE: {
                return Double.class;
            }
            case CHAR: {
                return Character.class;
            }
        }
        return (Class)AssertionUtil.assertUnreachable();
    }
}

