/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.BatchSqlValidator;
import org.seasar.doma.internal.apt.SqlValidator;
import org.seasar.doma.internal.apt.meta.AbstractSqlFileQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.DaoMeta;
import org.seasar.doma.internal.apt.meta.QueryKind;
import org.seasar.doma.internal.apt.meta.QueryMeta;
import org.seasar.doma.internal.apt.meta.QueryParameterMeta;
import org.seasar.doma.internal.apt.meta.QueryReturnMeta;
import org.seasar.doma.internal.apt.meta.SqlFileBatchModifyQueryMeta;
import org.seasar.doma.internal.apt.mirror.BatchDeleteMirror;
import org.seasar.doma.internal.apt.mirror.BatchInsertMirror;
import org.seasar.doma.internal.apt.mirror.BatchModifyMirror;
import org.seasar.doma.internal.apt.mirror.BatchUpdateMirror;
import org.seasar.doma.internal.apt.type.DataType;
import org.seasar.doma.internal.apt.type.EntityType;
import org.seasar.doma.internal.apt.type.IterableType;
import org.seasar.doma.internal.apt.type.SimpleDataTypeVisitor;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class SqlFileBatchModifyQueryMetaFactory
extends AbstractSqlFileQueryMetaFactory<SqlFileBatchModifyQueryMeta> {
    public SqlFileBatchModifyQueryMetaFactory(ProcessingEnvironment env) {
        super(env);
    }

    @Override
    public QueryMeta createQueryMeta(ExecutableElement method, DaoMeta daoMeta) {
        AssertionUtil.assertNotNull((Object)method, (Object)daoMeta);
        SqlFileBatchModifyQueryMeta queryMeta = this.createSqlFileBatchModifyQueryMeta(method, daoMeta);
        if (queryMeta == null) {
            return null;
        }
        this.doTypeParameters(queryMeta, method, daoMeta);
        this.doReturnType(queryMeta, method, daoMeta);
        this.doParameters(queryMeta, method, daoMeta);
        this.doThrowTypes(queryMeta, method, daoMeta);
        this.doSqlFiles(queryMeta, method, daoMeta);
        return queryMeta;
    }

    protected SqlFileBatchModifyQueryMeta createSqlFileBatchModifyQueryMeta(ExecutableElement method, DaoMeta daoMeta) {
        SqlFileBatchModifyQueryMeta queryMeta = new SqlFileBatchModifyQueryMeta(method);
        BatchModifyMirror batchModifyMirror = BatchInsertMirror.newInstance(method, this.env);
        if (batchModifyMirror != null && batchModifyMirror.getSqlFileValue()) {
            queryMeta.setBatchModifyMirror(batchModifyMirror);
            queryMeta.setQueryKind(QueryKind.SQLFILE_BATCH_INSERT);
            return queryMeta;
        }
        batchModifyMirror = BatchUpdateMirror.newInstance(method, this.env);
        if (batchModifyMirror != null && batchModifyMirror.getSqlFileValue()) {
            queryMeta.setBatchModifyMirror(batchModifyMirror);
            queryMeta.setQueryKind(QueryKind.SQLFILE_BATCH_UPDATE);
            return queryMeta;
        }
        batchModifyMirror = BatchDeleteMirror.newInstance(method, this.env);
        if (batchModifyMirror != null && batchModifyMirror.getSqlFileValue()) {
            queryMeta.setBatchModifyMirror(batchModifyMirror);
            queryMeta.setQueryKind(QueryKind.SQLFILE_BATCH_DELETE);
            return queryMeta;
        }
        return null;
    }

    @Override
    protected void doReturnType(SqlFileBatchModifyQueryMeta queryMeta, ExecutableElement method, DaoMeta daoMeta) {
        QueryReturnMeta resultMeta = this.createReturnMeta(method);
        if (!resultMeta.isPrimitiveIntArray()) {
            throw new AptException((MessageResource)Message.DOMA4040, this.env, (Element)resultMeta.getElement(), new Object[0]);
        }
        queryMeta.setReturnMeta(resultMeta);
    }

    @Override
    protected void doParameters(final SqlFileBatchModifyQueryMeta queryMeta, final ExecutableElement method, DaoMeta daoMeta) {
        List<? extends VariableElement> parameters = method.getParameters();
        int size = parameters.size();
        if (size != 1) {
            throw new AptException((MessageResource)Message.DOMA4002, this.env, (Element)method, new Object[0]);
        }
        QueryParameterMeta parameterMeta = this.createParameterMeta(parameters.get(0));
        IterableType iterableType = parameterMeta.getDataType().accept(new SimpleDataTypeVisitor<IterableType, Void, RuntimeException>(){

            @Override
            protected IterableType defaultAction(DataType type, Void p) throws RuntimeException {
                throw new AptException((MessageResource)Message.DOMA4042, SqlFileBatchModifyQueryMetaFactory.this.env, (Element)method, new Object[0]);
            }

            @Override
            public IterableType visitIterableType(IterableType dataType, Void p) throws RuntimeException {
                return dataType;
            }
        }, null);
        DataType elementType = iterableType.getElementType();
        queryMeta.setElementType(elementType);
        queryMeta.setElementsParameterName(parameterMeta.getName());
        elementType.accept(new SimpleDataTypeVisitor<Void, Void, RuntimeException>(){

            @Override
            public Void visitEntityType(EntityType dataType, Void p) throws RuntimeException {
                queryMeta.setEntityType(dataType);
                return null;
            }
        }, null);
        queryMeta.addParameterMeta(parameterMeta);
        if (parameterMeta.isBindable()) {
            queryMeta.addBindableParameterType(parameterMeta.getName(), elementType.getTypeMirror());
        }
    }

    @Override
    protected SqlValidator createSqlValidator(ExecutableElement method, Map<String, TypeMirror> parameterTypeMap, String sqlFilePath) {
        return new BatchSqlValidator(this.env, method, parameterTypeMap, sqlFilePath);
    }
}

