/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt;

import java.util.Date;
import javax.annotation.processing.ProcessingEnvironment;
import org.seasar.doma.internal.Artifact;

public final class Options {
    public static final String TEST = "test";
    public static final String DEBUG = "debug";
    public static final String DAO_PACKAGE = "dao.package";
    public static final String DAO_SUBPACKAGE = "dao.subpackage";
    public static final String DAO_SUFFIX = "dao.suffix";

    public static boolean isTestEnabled(ProcessingEnvironment env) {
        String test = env.getOptions().get(TEST);
        return Boolean.valueOf(test);
    }

    public static String getVersion(ProcessingEnvironment env) {
        if (Options.isTestEnabled(env)) {
            return "@VERSION@";
        }
        return Artifact.getVersion();
    }

    public static Date getDate(ProcessingEnvironment env) {
        if (Options.isTestEnabled(env)) {
            return new Date(0L);
        }
        return new Date();
    }

    public static boolean isDebugEnabled(ProcessingEnvironment env) {
        String debug = env.getOptions().get(DEBUG);
        return Boolean.valueOf(debug);
    }

    public static String getDaoPackage(ProcessingEnvironment env) {
        String pkg = env.getOptions().get(DAO_PACKAGE);
        return pkg != null ? pkg : null;
    }

    public static String getDaoSubpackage(ProcessingEnvironment env) {
        String subpackage = env.getOptions().get(DAO_SUBPACKAGE);
        return subpackage != null ? subpackage : null;
    }

    public static String getDaoSuffix(ProcessingEnvironment env) {
        String suffix = env.getOptions().get(DAO_SUFFIX);
        return suffix != null ? suffix : "Impl";
    }

    protected static class Constants {
        public static final String DEFAULT_DAO_SUFFIX = "Impl";

        protected Constants() {
        }
    }
}

