/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base.genfiles;

import com.google.appengine.repackaged.com.google.common.base.X;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectObjectMap
implements Iterable<Entry> {
    private static final Object EMPTY_KEY = null;
    private Object[] table;
    private Object[] value;
    private int count;
    private int bits1;
    private int bits2;
    private int enlarge_threshold;
    private int lookups;
    private int probes;
    private static final float MAX_OCCUPANCY = 0.8f;
    private static Object[] empty_table = new Object[0];
    private long last_stats = System.currentTimeMillis();
    private final boolean silent_;

    public ObjectObjectMap() {
        this(4);
    }

    public ObjectObjectMap(int n) {
        this(n, false);
    }

    public ObjectObjectMap(int n, boolean silent) {
        this.silent_ = silent;
        this.table = empty_table;
        this.resize(Math.max(3, n));
    }

    public void insert(Object key, Object val) {
        int index = this.find_index(key);
        Object old_elem = this.table[index];
        this.table[index] = key;
        this.value[index] = val;
        if (old_elem == EMPTY_KEY) {
            ++this.count;
            if (this.count >= this.enlarge_threshold) {
                this.resize(this.count * 2);
            }
        }
    }

    public boolean contains(Object key) {
        Object elem = this.table[this.find_index(key)];
        return elem != EMPTY_KEY;
    }

    public Object lookup(Object key, Object default_value) {
        int index = this.find_index(key);
        Object k = this.table[index];
        if (k == EMPTY_KEY) {
            return default_value;
        }
        return this.value[index];
    }

    public int size() {
        return this.count;
    }

    public int next(int i) {
        ++i;
        while (i < this.table.length) {
            Object key = this.table[i];
            if (key != EMPTY_KEY) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Iterator<Object> keyIterator() {
        return new HashIterator<Object>(this){

            @Override
            public Object next() {
                return this.map.keyAt(this.nextIndex());
            }
        };
    }

    public Iterator<Object> valueIterator() {
        return new HashIterator<Object>(this){

            @Override
            public Object next() {
                return this.map.valueAt(this.nextIndex());
            }
        };
    }

    @Override
    public Iterator<Entry> iterator() {
        return new HashIterator<Entry>(this){

            @Override
            public Entry next() {
                int next = this.nextIndex();
                return new Entry(this.map.keyAt(next), this.map.valueAt(next));
            }
        };
    }

    public Object[] toValueArray() {
        Object[] array = new Object[this.size()];
        int arrayIndex = 0;
        int mapIndex = -1;
        while ((mapIndex = this.next(mapIndex)) >= 0 && arrayIndex < array.length) {
            array[arrayIndex++] = this.valueAt(mapIndex);
        }
        return array;
    }

    public Object keyAt(int i) {
        return this.table[i];
    }

    public Object valueAt(int i) {
        return this.value[i];
    }

    public void setValueAt(int i, Object v) {
        this.value[i] = v;
    }

    private int find_index(Object key) {
        ++this.lookups;
        int n = this.table.length;
        int mult = key.hashCode() * -820265764 & Integer.MAX_VALUE;
        int h1 = mult >>> this.bits1 & n - 1;
        int h2 = mult >>> this.bits2 & n - 1 | 1;
        int index = h1;
        for (int i = 0; i < n; ++i) {
            ++this.probes;
            if (this.table[index] == EMPTY_KEY) {
                return index;
            }
            if (key.equals(this.table[index])) {
                return index;
            }
            index = index + h2 & n - 1;
        }
        throw new RuntimeException("Did not find empty slot for " + key);
    }

    public void resize(int desired) {
        if (desired < this.count) {
            desired = this.count;
        }
        int min_size = (int)((float)desired / 0.8f);
        int lg = 2;
        while (1 << lg < min_size) {
            ++lg;
        }
        int n = 1 << lg;
        if (n == this.count) {
            return;
        }
        Object[] old = this.table;
        this.table = new Object[n];
        Object[] oldval = this.value;
        this.value = new Object[n];
        this.enlarge_threshold = Math.min(n - 1, (int)((float)n * 0.8f));
        X.assertTrue(this.enlarge_threshold < n);
        this.count = 0;
        this.bits2 = Math.max(31 - 2 * lg, 0);
        this.bits1 = 31 - lg;
        for (int i = 0; i < old.length; ++i) {
            Object elem = old[i];
            if (elem == EMPTY_KEY) continue;
            this.insert(elem, oldval[i]);
        }
        if (!(this.table.length < 131072 && old.length < 131072 || this.silent_)) {
            this.stats("resize");
        }
    }

    public void stats(String label) {
        long now = System.currentTimeMillis();
        System.err.println((double)(now - this.last_stats) / 1000.0 + " " + label + " " + this.count + " cnt; " + this.table.length + " sz; " + this.enlarge_threshold + " th; " + this.lookups + "/" + this.probes);
        this.last_stats = now;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class HashIterator<E>
    implements Iterator<E> {
        private int nextIndex;
        private int currentIndex;
        ObjectObjectMap map;

        private HashIterator(ObjectObjectMap map) {
            this.map = map;
            this.nextIndex = map.next(-1);
            this.currentIndex = -1;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        int nextIndex() {
            this.currentIndex = this.nextIndex;
            this.nextIndex = this.map.next(this.currentIndex);
            return this.currentIndex;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class Entry {
        private final Object key;
        private final Object value;

        public Entry(Object k, Object v) {
            this.key = k;
            this.value = v;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

