/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.blobstore;

import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.blobstore.BlobstoreFailureException;
import com.google.appengine.api.blobstore.BlobstoreService;
import com.google.appengine.api.blobstore.BlobstoreServicePb;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BlobstoreServiceImpl
implements BlobstoreService {
    static final String PACKAGE = "blobstore";
    static final String SERVE_HEADER = "X-AppEngine-BlobKey";
    static final String UPLOADED_BLOBKEY_ATTR = "com.google.appengine.api.blobstore.upload.blobkeys";

    BlobstoreServiceImpl() {
    }

    @Override
    public String createUploadUrl(String successPath) {
        byte[] responseBytes;
        if (successPath == null) {
            throw new NullPointerException("Success path must not be null.");
        }
        BlobstoreServicePb.CreateUploadURLRequest request = new BlobstoreServicePb.CreateUploadURLRequest();
        request.setSuccessPath(successPath);
        try {
            responseBytes = ApiProxy.makeSyncCall(PACKAGE, "CreateUploadURL", request.toByteArray());
        }
        catch (ApiProxy.ApplicationException ex) {
            switch (BlobstoreServicePb.BlobstoreServiceError.ErrorCode.valueOf(ex.getApplicationError())) {
                case URL_TOO_LONG: {
                    throw new IllegalArgumentException("The resulting URL was too long.");
                }
                case INTERNAL_ERROR: {
                    throw new BlobstoreFailureException("An internal blobstore error occured.");
                }
            }
            throw new BlobstoreFailureException("An unexpected error occurred.", ex);
        }
        BlobstoreServicePb.CreateUploadURLResponse response = new BlobstoreServicePb.CreateUploadURLResponse();
        response.mergeFrom(responseBytes);
        return response.getUrl();
    }

    @Override
    public void serve(BlobKey blobKey, HttpServletResponse response) throws IOException {
        if (response.isCommitted()) {
            throw new IllegalStateException("Response was already committed.");
        }
        response.setStatus(200);
        response.setHeader(SERVE_HEADER, blobKey.getKeyString());
    }

    @Override
    public void delete(BlobKey ... blobKeys) {
        BlobstoreServicePb.DeleteBlobRequest request = new BlobstoreServicePb.DeleteBlobRequest();
        for (BlobKey blobKey : blobKeys) {
            request.addBlobKey(blobKey.getKeyString());
        }
        if (request.blobKeySize() == 0) {
            return;
        }
        try {
            byte[] responseBytes = ApiProxy.makeSyncCall(PACKAGE, "DeleteBlob", request.toByteArray());
        }
        catch (ApiProxy.ApplicationException ex) {
            switch (BlobstoreServicePb.BlobstoreServiceError.ErrorCode.valueOf(ex.getApplicationError())) {
                case INTERNAL_ERROR: {
                    throw new BlobstoreFailureException("An internal blobstore error occured.");
                }
            }
            throw new BlobstoreFailureException("An unexpected error occurred.", ex);
        }
    }

    @Override
    public Map<String, BlobKey> getUploadedBlobs(HttpServletRequest request) {
        Map attributes = (Map)request.getAttribute(UPLOADED_BLOBKEY_ATTR);
        if (attributes == null) {
            throw new IllegalStateException("Must be called from a blob upload callback request.");
        }
        HashMap<String, BlobKey> blobKeys = new HashMap<String, BlobKey>(attributes.size());
        for (Map.Entry attr : attributes.entrySet()) {
            blobKeys.put((String)attr.getKey(), new BlobKey((String)attr.getValue()));
        }
        return blobKeys;
    }
}

