/*
 * Decompiled with CFR 0.152.
 */
package org.slim3.gen.task;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.slim3.gen.generator.Generator;
import org.slim3.gen.message.MessageCode;
import org.slim3.gen.message.MessageFormatter;
import org.slim3.gen.printer.FilePrinter;
import org.slim3.gen.printer.Printer;
import org.slim3.gen.task.WebConfig;

public abstract class AbstractGenFileTask
extends Task {
    protected File warDir;
    protected String encoding = "UTF-8";

    public void setWarDir(File warDir) {
        this.warDir = warDir;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void execute() {
        try {
            this.doExecute();
        }
        catch (Exception e) {
            StringWriter writer = new StringWriter();
            e.printStackTrace(new PrintWriter(writer));
            throw new BuildException(writer.toString());
        }
    }

    protected void doExecute() throws Exception {
        if (this.warDir == null) {
            throw new IllegalStateException("The warDir parameter is null.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateFile(Generator generator, File file) throws IOException {
        if (file.exists()) {
            this.log(MessageFormatter.getSimpleMessage(MessageCode.SLIM3GEN0006, file.getAbsolutePath()));
            return;
        }
        Printer printer = null;
        try {
            printer = this.createPrinter(file);
            generator.generate(printer);
        }
        finally {
            if (printer != null) {
                printer.close();
            }
        }
        this.log(MessageFormatter.getSimpleMessage(MessageCode.SLIM3GEN0007, file.getAbsolutePath()));
    }

    protected Printer createPrinter(File file) throws IOException {
        return new FilePrinter(file, this.encoding);
    }

    protected WebConfig createWebConfig() {
        return new WebConfig(this.warDir);
    }
}

