/*
 * Decompiled with CFR 0.152.
 */
package org.slim3.gen.generator;

import java.util.Arrays;
import java.util.Date;
import org.slim3.gen.ProductInfo;
import org.slim3.gen.datastore.ArrayType;
import org.slim3.gen.datastore.BlobType;
import org.slim3.gen.datastore.CollectionType;
import org.slim3.gen.datastore.CorePrimitiveType;
import org.slim3.gen.datastore.CoreReferenceType;
import org.slim3.gen.datastore.DataType;
import org.slim3.gen.datastore.EnumType;
import org.slim3.gen.datastore.FloatType;
import org.slim3.gen.datastore.IntegerType;
import org.slim3.gen.datastore.KeyType;
import org.slim3.gen.datastore.LinkedHashSetType;
import org.slim3.gen.datastore.LinkedListType;
import org.slim3.gen.datastore.ListType;
import org.slim3.gen.datastore.LongType;
import org.slim3.gen.datastore.ModelRefType;
import org.slim3.gen.datastore.PrimitiveBooleanType;
import org.slim3.gen.datastore.PrimitiveByteType;
import org.slim3.gen.datastore.PrimitiveDoubleType;
import org.slim3.gen.datastore.PrimitiveFloatType;
import org.slim3.gen.datastore.PrimitiveIntType;
import org.slim3.gen.datastore.PrimitiveLongType;
import org.slim3.gen.datastore.PrimitiveShortType;
import org.slim3.gen.datastore.SetType;
import org.slim3.gen.datastore.ShortBlobType;
import org.slim3.gen.datastore.ShortType;
import org.slim3.gen.datastore.SimpleDataTypeVisitor;
import org.slim3.gen.datastore.SortedSetType;
import org.slim3.gen.datastore.StringType;
import org.slim3.gen.datastore.TextType;
import org.slim3.gen.desc.AttributeMetaDesc;
import org.slim3.gen.desc.ModelMetaDesc;
import org.slim3.gen.generator.Generator;
import org.slim3.gen.printer.Printer;
import org.slim3.gen.util.CollectionUtil;

public class ModelMetaGenerator
implements Generator {
    protected final ModelMetaDesc modelMetaDesc;

    public ModelMetaGenerator(ModelMetaDesc modelMetaDesc) {
        if (modelMetaDesc == null) {
            throw new NullPointerException("The modelMetaDesc parameter is null.");
        }
        this.modelMetaDesc = modelMetaDesc;
    }

    public void generate(Printer printer) {
        if (printer == null) {
            throw new NullPointerException("The printer parameter is null.");
        }
        this.printPackage(printer);
        this.printClass(printer);
    }

    protected void printPackage(Printer printer) {
        if (this.modelMetaDesc.getPackageName().length() != 0) {
            printer.println("package %s;", this.modelMetaDesc.getPackageName());
            printer.println();
        }
    }

    protected void printClass(Printer printer) {
        printer.println("//@javax.annotation.Generated(value = { \"%s\", \"%s\" }, date = \"%tF %<tT\")", ProductInfo.getName(), ProductInfo.getVersion(), new Date());
        printer.println("/** */", new Object[0]);
        printer.println("public final class %s extends %s<%s> {", this.modelMetaDesc.getSimpleName(), "org.slim3.datastore.ModelMeta", this.modelMetaDesc.getModelClassName());
        printer.println();
        printer.indent();
        this.printAttributeMetaFields(printer);
        this.printSingletonField(printer);
        this.printGetMethod(printer);
        this.printConstructor(printer);
        printer.unindent();
        printer.println();
        printer.indent();
        this.printEntityToModelMethod(printer);
        this.printModelToEntityMethod(printer);
        this.printGetKeyMethod(printer);
        this.printSetKeyMethod(printer);
        this.printGetVersion(printer);
        this.printIncrementVersionMethod(printer);
        printer.unindent();
        printer.print("}", new Object[0]);
    }

    protected void printAttributeMetaFields(Printer printer) {
        AttributeMetaFieldsGenerator generator = new AttributeMetaFieldsGenerator(printer);
        generator.generate();
    }

    protected void printSingletonField(Printer printer) {
        printer.println("private static final %1$s slim3_singleton = new %1$s();", this.modelMetaDesc.getSimpleName());
        printer.println();
    }

    protected void printConstructor(Printer printer) {
        printer.println("/** */", new Object[0]);
        printer.println("public %s() {", this.modelMetaDesc.getSimpleName());
        if (this.modelMetaDesc.getClassHierarchyList().isEmpty()) {
            printer.println("    super(\"%1$s\", %2$s.class);", this.modelMetaDesc.getKind(), this.modelMetaDesc.getModelClassName());
        } else {
            printer.println("    super(\"%1$s\", %2$s.class, %3$s.asList(%4$s));", this.modelMetaDesc.getKind(), this.modelMetaDesc.getModelClassName(), Arrays.class.getName(), CollectionUtil.join(this.modelMetaDesc.getClassHierarchyList(), ", "));
        }
        printer.println("}", new Object[0]);
    }

    protected void printGetMethod(Printer printer) {
        printer.println("/**", new Object[0]);
        printer.println(" * @return the singleton", new Object[0]);
        printer.println(" */", new Object[0]);
        printer.println("public static %1$s get() {", this.modelMetaDesc.getSimpleName());
        printer.println("   return slim3_singleton;", new Object[0]);
        printer.println("}", new Object[0]);
        printer.println();
    }

    protected void printEntityToModelMethod(Printer printer) {
        EntityToModelMethodGenerator generator = new EntityToModelMethodGenerator(printer);
        generator.generate();
    }

    protected void printModelToEntityMethod(Printer printer) {
        ModelToEntityMethodGenerator generator = new ModelToEntityMethodGenerator(printer);
        generator.generate();
    }

    protected void printGetVersion(final Printer printer) {
        printer.println("@Override", new Object[0]);
        printer.println("protected long getVersion(Object model) {", new Object[0]);
        final AttributeMetaDesc attr = this.modelMetaDesc.getVersionAttributeMetaDesc();
        if (attr == null) {
            printer.println("    throw new IllegalStateException(\"The version property of the model(%1$s) is not defined.\");", this.modelMetaDesc.getModelClassName());
        } else {
            printer.println("    %1$s m = (%1$s) model;", this.modelMetaDesc.getModelClassName());
            DataType dataType = attr.getDataType();
            dataType.accept(new SimpleDataTypeVisitor<Void, Void, RuntimeException>(){

                @Override
                protected Void defaultAction(DataType type, Void p) throws RuntimeException {
                    printer.println("    throw new IllegalStateException(\"The version property of the model(%1$s) is not defined.\");", ModelMetaGenerator.this.modelMetaDesc.getModelClassName());
                    return null;
                }

                @Override
                public Void visitPrimitiveLongType(PrimitiveLongType type, Void p) throws RuntimeException {
                    printer.println("    return m.%1$s();", attr.getReadMethodName());
                    return null;
                }

                @Override
                public Void visitLongType(LongType type, Void p) throws RuntimeException {
                    printer.println("    return m.%1$s() != null ? m.%1$s().longValue() : 0L;", attr.getReadMethodName());
                    return null;
                }
            }, null);
        }
        printer.println("}", new Object[0]);
        printer.println();
    }

    protected void printIncrementVersionMethod(final Printer printer) {
        printer.println("@Override", new Object[0]);
        printer.println("protected void incrementVersion(Object model) {", new Object[0]);
        final AttributeMetaDesc attr = this.modelMetaDesc.getVersionAttributeMetaDesc();
        if (attr != null) {
            printer.println("    %1$s m = (%1$s) model;", this.modelMetaDesc.getModelClassName());
            DataType dataType = attr.getDataType();
            dataType.accept(new SimpleDataTypeVisitor<Void, Void, RuntimeException>(){

                @Override
                protected Void defaultAction(DataType type, Void p) throws RuntimeException {
                    printer.println("    throw new IllegalStateException(\"The version property of the model(%1$s) is not defined.\");", ModelMetaGenerator.this.modelMetaDesc.getModelClassName());
                    return null;
                }

                @Override
                public Void visitPrimitiveLongType(PrimitiveLongType type, Void p) throws RuntimeException {
                    printer.println("    m.%1$s(m.%2$s() + 1L);", attr.getWriteMethodName(), attr.getReadMethodName());
                    return null;
                }

                @Override
                public Void visitLongType(LongType type, Void p) throws RuntimeException {
                    printer.println("    long version = m.%1$s() != null ? m.%1$s().longValue() : 0L;", attr.getReadMethodName());
                    printer.println("    m.%1$s(Long.valueOf(version + 1L));", attr.getWriteMethodName());
                    return null;
                }
            }, null);
        }
        printer.println("}", new Object[0]);
        printer.println();
    }

    protected void printGetKeyMethod(Printer printer) {
        printer.println("@Override", new Object[0]);
        printer.println("protected com.google.appengine.api.datastore.Key getKey(Object model) {", new Object[0]);
        AttributeMetaDesc attr = this.modelMetaDesc.getKeyAttributeMetaDesc();
        if (attr == null) {
            printer.println("    throw new IllegalStateException(\"The key property of the model(%1$s) is not defined.\");", this.modelMetaDesc.getModelClassName());
        } else {
            printer.println("    %1$s m = (%1$s) model;", this.modelMetaDesc.getModelClassName());
            printer.println("    return m.%1$s();", attr.getReadMethodName());
        }
        printer.println("}", new Object[0]);
        printer.println();
    }

    protected void printSetKeyMethod(Printer printer) {
        printer.println("@Override", new Object[0]);
        printer.println("protected void setKey(Object model, com.google.appengine.api.datastore.Key key) {", new Object[0]);
        AttributeMetaDesc attr = this.modelMetaDesc.getKeyAttributeMetaDesc();
        if (attr == null) {
            printer.println("    throw new IllegalStateException(\"The key property of the model(%1$s) is not defined.\");", this.modelMetaDesc.getModelClassName());
        } else {
            printer.println("    validateKey(key);", new Object[0]);
            printer.println("    %1$s m = (%1$s) model;", this.modelMetaDesc.getModelClassName());
            printer.println("    m.%1$s(key);", attr.getWriteMethodName());
        }
        printer.println("}", new Object[0]);
        printer.println();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ModelToEntityMethodGenerator
    extends SimpleDataTypeVisitor<Void, AttributeMetaDesc, RuntimeException> {
        protected final Printer printer;

        public ModelToEntityMethodGenerator(Printer printer) {
            this.printer = printer;
        }

        public void generate() {
            this.printer.println("@Override", new Object[0]);
            this.printer.println("public %1$s modelToEntity(%2$s model) {", "com.google.appengine.api.datastore.Entity", "java.lang.Object");
            this.printer.indent();
            if (ModelMetaGenerator.this.modelMetaDesc.isAbstrct()) {
                this.printer.println("throw new %1$s(\"The class(%2$s) is abstract.\");", UnsupportedOperationException.class.getName(), ModelMetaGenerator.this.modelMetaDesc.getModelClassName());
            } else {
                this.printer.println("%1$s m = (%1$s) model;", ModelMetaGenerator.this.modelMetaDesc.getModelClassName());
                this.printer.println("%1$s entity = null;", "com.google.appengine.api.datastore.Entity");
                this.printer.println("if (m.%1$s() != null) {", ModelMetaGenerator.this.modelMetaDesc.getKeyAttributeMetaDesc().getReadMethodName());
                this.printer.println("    entity = new %1$s(m.%2$s());", "com.google.appengine.api.datastore.Entity", ModelMetaGenerator.this.modelMetaDesc.getKeyAttributeMetaDesc().getReadMethodName());
                this.printer.println("} else {", new Object[0]);
                this.printer.println("    entity = new %1$s(kind);", "com.google.appengine.api.datastore.Entity");
                this.printer.println("}", new Object[0]);
                for (AttributeMetaDesc attr : ModelMetaGenerator.this.modelMetaDesc.getAttributeMetaDescList()) {
                    if (attr.isPrimaryKey()) continue;
                    DataType dataType = attr.getDataType();
                    dataType.accept(this, attr);
                }
                int schemaVersion = ModelMetaGenerator.this.modelMetaDesc.getSchemaVersion();
                if (schemaVersion > 0) {
                    this.printer.println("entity.setProperty(SCHEMA_VERSION_RESERVED_PROPERTY, %1$s);", ModelMetaGenerator.this.modelMetaDesc.getSchemaVersion());
                }
                if (!ModelMetaGenerator.this.modelMetaDesc.getClassHierarchyList().isEmpty()) {
                    this.printer.println("entity.setProperty(CLASS_HIERARCHY_LIST_RESERVED_PROPERTY, classHierarchyList);", new Object[0]);
                }
                this.printer.println("return entity;", new Object[0]);
            }
            this.printer.unindent();
            this.printer.println("}", new Object[0]);
            this.printer.println();
        }

        @Override
        protected Void defaultAction(DataType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("entity.setUnindexedProperty(\"%1$s\", serializableToBlob(m.%2$s()));", p.getName(), p.getReadMethodName());
            return null;
        }

        @Override
        public Void visitCorePrimitiveType(CorePrimitiveType type, AttributeMetaDesc p) throws RuntimeException {
            if (p.isUnindexed()) {
                this.printer.println("entity.setUnindexedProperty(\"%1$s\", m.%2$s());", p.getName(), p.getReadMethodName());
            } else {
                this.printer.println("entity.setProperty(\"%1$s\", m.%2$s());", p.getName(), p.getReadMethodName());
            }
            return null;
        }

        @Override
        public Void visitCoreReferenceType(CoreReferenceType type, AttributeMetaDesc p) throws RuntimeException {
            if (p.isUnindexed()) {
                this.printer.println("entity.setUnindexedProperty(\"%1$s\", m.%2$s());", p.getName(), p.getReadMethodName());
            } else {
                this.printer.println("entity.setProperty(\"%1$s\", m.%2$s());", p.getName(), p.getReadMethodName());
            }
            return null;
        }

        @Override
        public Void visitStringType(StringType type, AttributeMetaDesc p) throws RuntimeException {
            if (p.isLob()) {
                this.printer.println("entity.setUnindexedProperty(\"%1$s\", stringToText(m.%2$s()));", p.getName(), p.getReadMethodName());
                return null;
            }
            return (Void)super.visitStringType(type, p);
        }

        @Override
        public Void visitEnumType(EnumType type, AttributeMetaDesc p) throws RuntimeException {
            if (p.isUnindexed()) {
                this.printer.println("entity.setUnindexedProperty(\"%1$s\", enumToString(m.%2$s()));", p.getName(), p.getReadMethodName());
            } else {
                this.printer.println("entity.setProperty(\"%1$s\", enumToString(m.%2$s()));", p.getName(), p.getReadMethodName());
            }
            return null;
        }

        @Override
        public Void visitTextType(TextType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("entity.setUnindexedProperty(\"%1$s\", m.%2$s());", p.getName(), p.getReadMethodName());
            return null;
        }

        @Override
        public Void visitModelRefType(ModelRefType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("if (m.%1$s() == null) {", p.getReadMethodName());
            this.printer.println("    throw new NullPointerException(\"The property(%1$s) must not be null.\");", p.getFieldName());
            this.printer.println("}", new Object[0]);
            if (p.isUnindexed()) {
                this.printer.println("entity.setUnindexedProperty(\"%1$s\", %2$s.assignKeyIfNecessary(m.%3$s().getModelMeta(), m.%3$s().getModel()));", p.getName(), "org.slim3.datastore.ModelMeta", p.getReadMethodName());
            } else {
                this.printer.println("entity.setProperty(\"%1$s\", %2$s.assignKeyIfNecessary(m.%3$s().getModelMeta(), m.%3$s().getModel()));", p.getName(), "org.slim3.datastore.ModelMeta", p.getReadMethodName());
            }
            return null;
        }

        @Override
        public Void visitArrayType(ArrayType type, final AttributeMetaDesc attr) throws RuntimeException {
            DataType componentType = type.getComponentType();
            boolean accepted = componentType.accept(new SimpleDataTypeVisitor<Boolean, Void, RuntimeException>(Boolean.valueOf(false)){

                @Override
                public Boolean visitPrimitiveByteType(PrimitiveByteType type, Void p) throws RuntimeException {
                    ModelToEntityMethodGenerator.this.printer.println("entity.setUnindexedProperty(\"%1$s\", bytesToBlob(m.%2$s()));", attr.getName(), attr.getReadMethodName());
                    return true;
                }
            }, null);
            if (accepted) {
                return null;
            }
            return (Void)super.visitArrayType(type, attr);
        }

        @Override
        public Void visitCollectionType(CollectionType type, AttributeMetaDesc p) throws RuntimeException {
            if (p.isLob()) {
                return (Void)super.visitCollectionType(type, p);
            }
            if (p.isUnindexed()) {
                this.printer.println("entity.setUnindexedProperty(\"%1$s\", m.%2$s());", p.getName(), p.getReadMethodName());
            } else {
                this.printer.println("entity.setProperty(\"%1$s\", m.%2$s());", p.getName(), p.getReadMethodName());
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class EntityToModelMethodGenerator
    extends SimpleDataTypeVisitor<Void, AttributeMetaDesc, RuntimeException> {
        protected final Printer printer;

        public EntityToModelMethodGenerator(Printer printer) {
            this.printer = printer;
        }

        public void generate() {
            this.printer.println("@Override", new Object[0]);
            this.printer.println("public %1$s entityToModel(%2$s entity) {", ModelMetaGenerator.this.modelMetaDesc.getModelClassName(), "com.google.appengine.api.datastore.Entity");
            this.printer.indent();
            if (ModelMetaGenerator.this.modelMetaDesc.isAbstrct()) {
                this.printer.println("throw new %1$s(\"The class(%2$s) is abstract.\");", UnsupportedOperationException.class.getName(), ModelMetaGenerator.this.modelMetaDesc.getModelClassName());
            } else {
                this.printer.println("%1$s model = new %1$s();", ModelMetaGenerator.this.modelMetaDesc.getModelClassName());
                for (AttributeMetaDesc attr : ModelMetaGenerator.this.modelMetaDesc.getAttributeMetaDescList()) {
                    DataType dataType = attr.getDataType();
                    dataType.accept(this, attr);
                }
                this.printer.println("return model;", new Object[0]);
            }
            this.printer.unindent();
            this.printer.println("}", new Object[0]);
            this.printer.println();
        }

        @Override
        protected Void defaultAction(DataType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("%1$s _%2$s = blobToSerializable((%3$s) entity.getProperty(\"%4$s\"));", type.getTypeName(), p.getFieldName(), "com.google.appengine.api.datastore.Blob", p.getName());
            this.printer.println("model.%1$s(_%2$s);", p.getWriteMethodName(), p.getFieldName());
            return null;
        }

        @Override
        public Void visitPrimitiveBooleanType(PrimitiveBooleanType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("model.%1$s(booleanToPrimitiveBoolean((%2$s) entity.getProperty(\"%3$s\")));", p.getWriteMethodName(), type.getWrapperClassName(), p.getName());
            return null;
        }

        @Override
        public Void visitPrimitiveDoubleType(PrimitiveDoubleType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("model.%1$s(doubleToPrimitiveDouble((%2$s) entity.getProperty(\"%3$s\")));", p.getWriteMethodName(), type.getWrapperClassName(), p.getName());
            return null;
        }

        @Override
        public Void visitPrimitiveFloatType(PrimitiveFloatType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("model.%1$s(doubleToPrimitiveFloat((%2$s) entity.getProperty(\"%3$s\")));", p.getWriteMethodName(), "java.lang.Double", p.getName());
            return null;
        }

        @Override
        public Void visitPrimitiveIntType(PrimitiveIntType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("model.%1$s(longToPrimitiveInt((%2$s) entity.getProperty(\"%3$s\")));", p.getWriteMethodName(), "java.lang.Long", p.getName());
            return null;
        }

        @Override
        public Void visitPrimitiveLongType(PrimitiveLongType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("model.%1$s(longToPrimitiveLong((%2$s) entity.getProperty(\"%3$s\")));", p.getWriteMethodName(), type.getWrapperClassName(), p.getName());
            return null;
        }

        @Override
        public Void visitPrimitiveShortType(PrimitiveShortType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("model.%1$s(longToPrimitiveShort((%2$s) entity.getProperty(\"%3$s\")));", p.getWriteMethodName(), "java.lang.Long", p.getName());
            return null;
        }

        @Override
        public Void visitCoreReferenceType(CoreReferenceType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("model.%1$s((%2$s) entity.getProperty(\"%3$s\"));", p.getWriteMethodName(), type.getTypeName(), p.getName());
            return null;
        }

        @Override
        public Void visitFloatType(FloatType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("model.%1$s(doubleToFloat((%2$s) entity.getProperty(\"%3$s\")));", p.getWriteMethodName(), "java.lang.Double", p.getName());
            return null;
        }

        @Override
        public Void visitIntegerType(IntegerType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("model.%1$s(longToInteger((%2$s) entity.getProperty(\"%3$s\")));", p.getWriteMethodName(), "java.lang.Long", p.getName());
            return null;
        }

        @Override
        public Void visitShortType(ShortType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("model.%1$s(longToShort((%2$s) entity.getProperty(\"%3$s\")));", p.getWriteMethodName(), "java.lang.Long", p.getName());
            return null;
        }

        @Override
        public Void visitStringType(StringType type, AttributeMetaDesc p) throws RuntimeException {
            if (p.isLob()) {
                this.printer.println("model.%1$s(textToString((%2$s) entity.getProperty(\"%3$s\")));", p.getWriteMethodName(), "com.google.appengine.api.datastore.Text", p.getName());
                return null;
            }
            return (Void)super.visitStringType(type, p);
        }

        @Override
        public Void visitEnumType(EnumType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("model.%1$s(stringToEnum(%2$s.class, (%3$s) entity.getProperty(\"%4$s\")));", p.getWriteMethodName(), type.getTypeName(), "java.lang.String", p.getName());
            return null;
        }

        @Override
        public Void visitKeyType(KeyType type, AttributeMetaDesc p) throws RuntimeException {
            if (p.isPrimaryKey()) {
                this.printer.println("model.%1$s(entity.getKey());", p.getWriteMethodName());
            } else {
                this.printer.println("model.%1$s((%2$s) entity.getProperty(\"%3$s\"));", p.getWriteMethodName(), type.getTypeName(), p.getName());
            }
            return null;
        }

        @Override
        public Void visitModelRefType(ModelRefType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("if (model.%1$s() == null) {", p.getReadMethodName());
            this.printer.println("    throw new NullPointerException(\"The property(%1$s) is null.\");", p.getFieldName());
            this.printer.println("}", new Object[0]);
            this.printer.println("model.%1$s().setKey((%2$s) entity.getProperty(\"%3$s\"));", p.getReadMethodName(), "com.google.appengine.api.datastore.Key", p.getName());
            return null;
        }

        @Override
        public Void visitArrayType(ArrayType type, final AttributeMetaDesc attr) throws RuntimeException {
            DataType componentType = type.getComponentType();
            boolean accepted = componentType.accept(new SimpleDataTypeVisitor<Boolean, Void, RuntimeException>(Boolean.valueOf(false)){

                @Override
                public Boolean visitPrimitiveByteType(PrimitiveByteType type, Void p) throws RuntimeException {
                    EntityToModelMethodGenerator.this.printer.println("model.%1$s(blobToBytes((%2$s) entity.getProperty(\"%3$s\")));", attr.getWriteMethodName(), "com.google.appengine.api.datastore.Blob", attr.getName());
                    return true;
                }
            }, null);
            if (accepted) {
                return null;
            }
            return (Void)super.visitArrayType(type, attr);
        }

        @Override
        public Void visitListType(ListType collectionType, final AttributeMetaDesc attr) throws RuntimeException {
            DataType elementType = collectionType.getElementType();
            Boolean handled = elementType.accept(new SimpleDataTypeVisitor<Boolean, Void, RuntimeException>(Boolean.valueOf(false)){

                @Override
                public Boolean visitCoreReferenceType(CoreReferenceType type, Void p) throws RuntimeException {
                    EntityToModelMethodGenerator.this.printer.println("model.%1$s(toList(%2$s.class, entity.getProperty(\"%3$s\")));", attr.getWriteMethodName(), type.getClassName(), attr.getName());
                    return true;
                }

                @Override
                public Boolean visitShortType(ShortType type, Void p) throws RuntimeException {
                    EntityToModelMethodGenerator.this.printer.println("model.%1$s(longListToShortList(entity.getProperty(\"%2$s\")));", attr.getWriteMethodName(), attr.getName());
                    return true;
                }

                @Override
                public Boolean visitIntegerType(IntegerType type, Void p) throws RuntimeException {
                    EntityToModelMethodGenerator.this.printer.println("model.%1$s(longListToIntegerList(entity.getProperty(\"%2$s\")));", attr.getWriteMethodName(), attr.getName());
                    return true;
                }

                @Override
                public Boolean visitFloatType(FloatType type, Void p) throws RuntimeException {
                    EntityToModelMethodGenerator.this.printer.println("model.%1$s(doubleListToFloatList(entity.getProperty(\"%2$s\")));", attr.getWriteMethodName(), attr.getName());
                    return true;
                }
            }, null);
            return handled != false ? null : (Void)super.visitListType(collectionType, attr);
        }

        @Override
        public Void visitLinkedListType(LinkedListType collectionType, final AttributeMetaDesc attr) throws RuntimeException {
            DataType elementType = collectionType.getElementType();
            Boolean handled = elementType.accept(new SimpleDataTypeVisitor<Boolean, Void, RuntimeException>(Boolean.valueOf(false)){

                @Override
                public Boolean visitCoreReferenceType(CoreReferenceType type, Void p) throws RuntimeException {
                    EntityToModelMethodGenerator.this.printer.println("model.%1$s(new %4$s<%2$s>(toList(%2$s.class, entity.getProperty(\"%3$s\"))));", attr.getWriteMethodName(), type.getClassName(), attr.getName(), "java.util.LinkedList");
                    return true;
                }

                @Override
                public Boolean visitShortType(ShortType type, Void p) throws RuntimeException {
                    EntityToModelMethodGenerator.this.printer.println("model.%1$s(new %3$s<%4$s>(longListToShortList(entity.getProperty(\"%2$s\"))));", attr.getWriteMethodName(), attr.getName(), "java.util.LinkedList", "java.lang.Short");
                    return true;
                }

                @Override
                public Boolean visitIntegerType(IntegerType type, Void p) throws RuntimeException {
                    EntityToModelMethodGenerator.this.printer.println("model.%1$s(new %3$s<%4$s>(longListToIntegerList(entity.getProperty(\"%2$s\"))));", attr.getWriteMethodName(), attr.getName(), "java.util.LinkedList", "java.lang.Integer");
                    return true;
                }

                @Override
                public Boolean visitFloatType(FloatType type, Void p) throws RuntimeException {
                    EntityToModelMethodGenerator.this.printer.println("model.%1$s(new %3$s<%4$s>(doubleListToFloatList(entity.getProperty(\"%2$s\"))));", attr.getWriteMethodName(), attr.getName(), "java.util.LinkedList", "java.lang.Float");
                    return true;
                }
            }, null);
            return handled != false ? null : (Void)super.visitListType(collectionType, attr);
        }

        @Override
        public Void visitSetType(SetType collectionType, final AttributeMetaDesc attr) throws RuntimeException {
            DataType elementType = collectionType.getElementType();
            Boolean handled = elementType.accept(new SimpleDataTypeVisitor<Boolean, Void, RuntimeException>(Boolean.valueOf(false)){

                @Override
                public Boolean visitCoreReferenceType(CoreReferenceType type, Void p) throws RuntimeException {
                    EntityToModelMethodGenerator.this.printer.println("model.%1$s(new %4$s<%2$s>(toList(%2$s.class, entity.getProperty(\"%3$s\"))));", attr.getWriteMethodName(), type.getClassName(), attr.getName(), "java.util.HashSet");
                    return true;
                }

                @Override
                public Boolean visitShortType(ShortType type, Void p) throws RuntimeException {
                    EntityToModelMethodGenerator.this.printer.println("model.%1$s(new %3$s<%4$s>(longListToShortList(entity.getProperty(\"%2$s\"))));", attr.getWriteMethodName(), attr.getName(), "java.util.HashSet", "java.lang.Short");
                    return true;
                }

                @Override
                public Boolean visitIntegerType(IntegerType type, Void p) throws RuntimeException {
                    EntityToModelMethodGenerator.this.printer.println("model.%1$s(new %3$s<%4$s>(longListToIntegerList(entity.getProperty(\"%2$s\"))));", attr.getWriteMethodName(), attr.getName(), "java.util.HashSet", "java.lang.Integer");
                    return true;
                }

                @Override
                public Boolean visitFloatType(FloatType type, Void p) throws RuntimeException {
                    EntityToModelMethodGenerator.this.printer.println("model.%1$s(new %3$s<%4$s>(doubleListToFloatList(entity.getProperty(\"%2$s\"))));", attr.getWriteMethodName(), attr.getName(), "java.util.HashSet", "java.lang.Float");
                    return true;
                }
            }, null);
            return handled != false ? null : (Void)super.visitSetType(collectionType, attr);
        }

        @Override
        public Void visitLinkedHashSetType(LinkedHashSetType collectionType, final AttributeMetaDesc attr) throws RuntimeException {
            DataType elementType = collectionType.getElementType();
            Boolean handled = elementType.accept(new SimpleDataTypeVisitor<Boolean, Void, RuntimeException>(Boolean.valueOf(false)){

                @Override
                public Boolean visitCoreReferenceType(CoreReferenceType type, Void p) throws RuntimeException {
                    EntityToModelMethodGenerator.this.printer.println("model.%1$s(new %4$s<%2$s>(toList(%2$s.class, entity.getProperty(\"%3$s\"))));", attr.getWriteMethodName(), type.getClassName(), attr.getName(), "java.util.LinkedHashSet");
                    return true;
                }

                @Override
                public Boolean visitShortType(ShortType type, Void p) throws RuntimeException {
                    EntityToModelMethodGenerator.this.printer.println("model.%1$s(new %3$s<%4$s>(longListToShortList(entity.getProperty(\"%2$s\"))));", attr.getWriteMethodName(), attr.getName(), "java.util.LinkedHashSet", "java.lang.Short");
                    return true;
                }

                @Override
                public Boolean visitIntegerType(IntegerType type, Void p) throws RuntimeException {
                    EntityToModelMethodGenerator.this.printer.println("model.%1$s(new %3$s<%4$s>(longListToIntegerList(entity.getProperty(\"%2$s\"))));", attr.getWriteMethodName(), attr.getName(), "java.util.LinkedHashSet", "java.lang.Integer");
                    return true;
                }

                @Override
                public Boolean visitFloatType(FloatType type, Void p) throws RuntimeException {
                    EntityToModelMethodGenerator.this.printer.println("model.%1$s(new %3$s<%4$s>(doubleListToFloatList(entity.getProperty(\"%2$s\"))));", attr.getWriteMethodName(), attr.getName(), "java.util.LinkedHashSet", "java.lang.Float");
                    return true;
                }
            }, null);
            return handled != false ? null : (Void)super.visitSetType(collectionType, attr);
        }

        @Override
        public Void visitSortedSetType(SortedSetType collectionType, final AttributeMetaDesc attr) throws RuntimeException {
            DataType elementType = collectionType.getElementType();
            Boolean handled = elementType.accept(new SimpleDataTypeVisitor<Boolean, Void, RuntimeException>(Boolean.valueOf(false)){

                @Override
                public Boolean visitCoreReferenceType(CoreReferenceType type, Void p) throws RuntimeException {
                    EntityToModelMethodGenerator.this.printer.println("model.%1$s(new %4$s<%2$s>(toList(%2$s.class, entity.getProperty(\"%3$s\"))));", attr.getWriteMethodName(), type.getClassName(), attr.getName(), "java.util.TreeSet");
                    return true;
                }

                @Override
                public Boolean visitShortType(ShortType type, Void p) throws RuntimeException {
                    EntityToModelMethodGenerator.this.printer.println("model.%1$s(new %3$s<%4$s>(longListToShortList(entity.getProperty(\"%2$s\"))));", attr.getWriteMethodName(), attr.getName(), "java.util.TreeSet", "java.lang.Short");
                    return true;
                }

                @Override
                public Boolean visitIntegerType(IntegerType type, Void p) throws RuntimeException {
                    EntityToModelMethodGenerator.this.printer.println("model.%1$s(new %3$s<%4$s>(longListToIntegerList(entity.getProperty(\"%2$s\"))));", attr.getWriteMethodName(), attr.getName(), "java.util.TreeSet", "java.lang.Integer");
                    return true;
                }

                @Override
                public Boolean visitFloatType(FloatType type, Void p) throws RuntimeException {
                    EntityToModelMethodGenerator.this.printer.println("model.%1$s(new %3$s<%4$s>(doubleListToFloatList(entity.getProperty(\"%2$s\"))));", attr.getWriteMethodName(), attr.getName(), "java.util.TreeSet", "java.lang.Float");
                    return true;
                }
            }, null);
            return handled != false ? null : (Void)super.visitSortedSetType(collectionType, attr);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class AttributeMetaFieldsGenerator
    extends SimpleDataTypeVisitor<Void, AttributeMetaDesc, RuntimeException> {
        protected final Printer printer;

        protected AttributeMetaFieldsGenerator(Printer printer) {
            this.printer = printer;
        }

        public void generate() {
            for (AttributeMetaDesc attr : ModelMetaGenerator.this.modelMetaDesc.getAttributeMetaDescList()) {
                DataType dataType = attr.getDataType();
                if (attr.isLob() || attr.isUnindexed()) {
                    this.printer.println("/** */", new Object[0]);
                    this.printer.println("protected final %1$s<%2$s, %3$s> %4$s = new %1$s<%2$s, %3$s>(this, \"%5$s\", \"%4$s\", %6$s.class);", "org.slim3.datastore.UnindexedAttributeMeta", ModelMetaGenerator.this.modelMetaDesc.getModelClassName(), dataType.getTypeName(), attr.getFieldName(), attr.getName(), dataType.getClassName());
                    this.printer.println();
                    continue;
                }
                dataType.accept(this, attr);
            }
        }

        @Override
        public Void visitCorePrimitiveType(CorePrimitiveType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("/** */", new Object[0]);
            this.printer.println("public final %1$s<%2$s, %3$s> %4$s = new %1$s<%2$s, %3$s>(this, \"%5$s\", \"%4$s\", %6$s.class);", "org.slim3.datastore.CoreAttributeMeta", ModelMetaGenerator.this.modelMetaDesc.getModelClassName(), type.getWrapperClassName(), p.getFieldName(), p.getName(), type.getClassName());
            this.printer.println();
            return null;
        }

        @Override
        public Void visitCoreReferenceType(CoreReferenceType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("/** */", new Object[0]);
            this.printer.println("public final %1$s<%2$s, %3$s> %4$s = new %1$s<%2$s, %3$s>(this, \"%5$s\", \"%4$s\", %6$s.class);", "org.slim3.datastore.CoreAttributeMeta", ModelMetaGenerator.this.modelMetaDesc.getModelClassName(), type.getTypeName(), p.getFieldName(), p.getName(), type.getClassName());
            this.printer.println();
            return null;
        }

        @Override
        public Void visitModelRefType(ModelRefType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("/** */", new Object[0]);
            this.printer.println("public final %1$s<%2$s, %3$s, %4$s> %5$s = new %1$s<%2$s, %3$s, %4$s>(this, \"%6$s\", \"%5$s\", %7$s.class, %8$s.class);", "org.slim3.datastore.ModelRefAttributeMeta", ModelMetaGenerator.this.modelMetaDesc.getModelClassName(), type.getTypeName(), type.getReferenceModelTypeName(), p.getFieldName(), p.getName(), type.getClassName(), type.getReferenceModelTypeName());
            this.printer.println();
            return null;
        }

        @Override
        public Void visitKeyType(KeyType type, AttributeMetaDesc p) throws RuntimeException {
            String propertyName = "__key__";
            if (!p.isPrimaryKey()) {
                propertyName = p.getName();
            }
            this.printer.println("/** */", new Object[0]);
            this.printer.println("public final %1$s<%2$s, %3$s> %4$s = new %1$s<%2$s, %3$s>(this, \"%5$s\", \"%4$s\", %6$s.class);", "org.slim3.datastore.CoreAttributeMeta", ModelMetaGenerator.this.modelMetaDesc.getModelClassName(), type.getTypeName(), p.getFieldName(), propertyName, type.getClassName());
            this.printer.println();
            return null;
        }

        @Override
        public Void visitStringType(StringType type, AttributeMetaDesc p) throws RuntimeException {
            this.printer.println("/** */", new Object[0]);
            this.printer.println("public final %1$s<%2$s> %3$s = new %1$s<%2$s>(this, \"%4$s\", \"%3$s\");", "org.slim3.datastore.StringAttributeMeta", ModelMetaGenerator.this.modelMetaDesc.getModelClassName(), p.getFieldName(), p.getName());
            this.printer.println();
            return null;
        }

        @Override
        public Void visitShortBlobType(ShortBlobType type, AttributeMetaDesc p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitBlobType(BlobType type, AttributeMetaDesc p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitTextType(TextType type, AttributeMetaDesc p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitCollectionType(final CollectionType collectionType, final AttributeMetaDesc attr) throws RuntimeException {
            DataType elementType = collectionType.getElementType();
            elementType.accept(new SimpleDataTypeVisitor<Void, Void, RuntimeException>(){

                @Override
                public Void visitStringType(StringType type, Void p) throws RuntimeException {
                    AttributeMetaFieldsGenerator.this.printer.println("/** */", new Object[0]);
                    AttributeMetaFieldsGenerator.this.printer.println("public final %1$s<%2$s, %3$s> %4$s = new %1$s<%2$s, %3$s>(this, \"%5$s\", \"%4$s\", %6$s.class);", "org.slim3.datastore.StringCollectionAttributeMeta", ModelMetaGenerator.this.modelMetaDesc.getModelClassName(), collectionType.getTypeName(), attr.getFieldName(), attr.getName(), collectionType.getClassName());
                    AttributeMetaFieldsGenerator.this.printer.println();
                    return null;
                }

                @Override
                public Void visitCoreReferenceType(CoreReferenceType elementType, Void p) throws RuntimeException {
                    AttributeMetaFieldsGenerator.this.printer.println("/** */", new Object[0]);
                    AttributeMetaFieldsGenerator.this.printer.println("public final %1$s<%2$s, %3$s, %4$s> %5$s = new %1$s<%2$s, %3$s, %4$s>(this, \"%6$s\", \"%5$s\", %7$s.class);", "org.slim3.datastore.CollectionAttributeMeta", ModelMetaGenerator.this.modelMetaDesc.getModelClassName(), collectionType.getTypeName(), elementType.getTypeName(), attr.getFieldName(), attr.getName(), collectionType.getClassName());
                    AttributeMetaFieldsGenerator.this.printer.println();
                    return null;
                }
            }, null);
            return null;
        }
    }
}

