/*
 * Decompiled with CFR 0.152.
 */
package org.slim3.gen.desc;

import org.slim3.gen.desc.ViewDesc;
import org.slim3.gen.util.StringUtil;

public class ViewDescFactory {
    public ViewDesc createViewDesc(String path) {
        if (path == null) {
            throw new NullPointerException("The path parameter is null.");
        }
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("The path does not start with '/'.");
        }
        int pos = path.lastIndexOf("/");
        String dirName = path.substring(0, pos);
        String fileName = path.substring(pos + 1);
        fileName = fileName.length() == 0 ? "index.jsp" : fileName + ".jsp";
        ViewDesc viewDesc = new ViewDesc();
        viewDesc.setDirName(dirName);
        viewDesc.setFileName(fileName);
        viewDesc.setRelativePath(this.toRelativePath(path));
        viewDesc.setTitle(this.toTitle(path));
        return viewDesc;
    }

    protected String toRelativePath(String path) {
        int pos = path.lastIndexOf("/");
        return path.substring(pos + 1);
    }

    protected String toTitle(String path) {
        if (path.endsWith("/")) {
            return path.substring(1).replace("/", " ") + StringUtil.capitalize("index");
        }
        int pos = path.lastIndexOf("/");
        if (pos == 0) {
            return StringUtil.capitalize(path.substring(1));
        }
        if (pos > 0) {
            return path.substring(1, pos).replace("/", " ") + " " + StringUtil.capitalize(path.substring(pos + 1));
        }
        throw new IllegalArgumentException("path");
    }
}

