/*
 * Decompiled with CFR 0.152.
 */
package org.slim3.gen.desc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slim3.gen.desc.AttributeMetaDesc;
import org.slim3.gen.desc.ClassDesc;
import org.slim3.gen.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelMetaDesc
implements ClassDesc {
    protected final String packageName;
    protected final String simpleName;
    protected final boolean abstrct;
    protected final String modelClassName;
    protected final String kind;
    protected final int schemaVersion;
    protected final List<String> classHierarchyList;
    protected AttributeMetaDesc keyAttributeMetaDesc;
    protected AttributeMetaDesc versionAttributeMetaDesc;
    protected final List<AttributeMetaDesc> attributeMetaDescList = new ArrayList<AttributeMetaDesc>();
    protected boolean error;

    public ModelMetaDesc(String packageName, String simpleName, boolean abstrct, String modelClassName, String kind, int schemaVersion, List<String> classHierarchyList) {
        if (packageName == null) {
            throw new NullPointerException("The packageName parameter is null.");
        }
        if (simpleName == null) {
            throw new NullPointerException("The simpleName parameter is null.");
        }
        if (modelClassName == null) {
            throw new NullPointerException("The modelClassName parameter is null.");
        }
        if (kind == null) {
            throw new NullPointerException("The kind parameter is null.");
        }
        this.packageName = packageName;
        this.simpleName = simpleName;
        this.abstrct = abstrct;
        this.modelClassName = modelClassName;
        this.kind = kind;
        this.schemaVersion = schemaVersion;
        this.classHierarchyList = classHierarchyList;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public String getSimpleName() {
        return this.simpleName;
    }

    @Override
    public String getQualifiedName() {
        return ClassUtil.getQualifiedName(this.packageName, this.simpleName);
    }

    public boolean isAbstrct() {
        return this.abstrct;
    }

    public String getModelClassName() {
        return this.modelClassName;
    }

    public String getKind() {
        return this.kind;
    }

    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    public List<String> getClassHierarchyList() {
        return this.classHierarchyList;
    }

    public void addAttributeMetaDesc(AttributeMetaDesc attributeMetaDesc) {
        if (attributeMetaDesc.isPrimaryKey()) {
            this.keyAttributeMetaDesc = attributeMetaDesc;
        }
        if (attributeMetaDesc.isVersion()) {
            this.versionAttributeMetaDesc = attributeMetaDesc;
        }
        this.attributeMetaDescList.add(attributeMetaDesc);
    }

    public List<AttributeMetaDesc> getAttributeMetaDescList() {
        return Collections.unmodifiableList(this.attributeMetaDescList);
    }

    public AttributeMetaDesc getKeyAttributeMetaDesc() {
        return this.keyAttributeMetaDesc;
    }

    public AttributeMetaDesc getVersionAttributeMetaDesc() {
        return this.versionAttributeMetaDesc;
    }

    public boolean isError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }
}

