/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.log;

import java.util.Map;
import org.seasar.util.collection.ArrayUtil;
import org.seasar.util.collection.CollectionsUtil;
import org.seasar.util.exception.SIllegalArgumentException;
import org.seasar.util.log.JclLoggerAdapterFactory;
import org.seasar.util.log.JulLoggerAdapterFactory;
import org.seasar.util.log.LoggerAdapter;
import org.seasar.util.log.LoggerAdapterFactory;
import org.seasar.util.message.MessageFormatter;
import org.seasar.util.misc.AssertionUtil;
import org.seasar.util.misc.Disposable;
import org.seasar.util.misc.DisposableUtil;

public class Logger {
    protected static final LoggerAdapterFactory factory = Logger.getLoggerAdapterFactory();
    protected static final Map<Class<?>, Logger> loggers = CollectionsUtil.newHashMap();
    private static boolean initialized;
    private final LoggerAdapter log;

    public static synchronized Logger getLogger(Class<?> clazz) {
        Logger logger;
        AssertionUtil.assertArgumentNotNull("clazz", clazz);
        if (!initialized) {
            Logger.initialize();
        }
        if ((logger = loggers.get(clazz)) == null) {
            logger = new Logger(clazz);
            loggers.put(clazz, logger);
        }
        return logger;
    }

    public static LogMessage format(String messageCode, Object ... args) {
        AssertionUtil.assertArgumentNotEmpty("messageCode", messageCode);
        char messageType = messageCode.charAt(0);
        String message = MessageFormatter.getSimpleMessage(messageCode, args);
        switch (messageType) {
            case 'D': {
                return new LogMessage(LogLevel.DEBUG, message);
            }
            case 'I': {
                return new LogMessage(LogLevel.INFO, message);
            }
            case 'W': {
                return new LogMessage(LogLevel.WARN, message);
            }
            case 'E': {
                return new LogMessage(LogLevel.ERROR, message);
            }
            case 'F': {
                return new LogMessage(LogLevel.FATAL, message);
            }
        }
        throw new SIllegalArgumentException("messageCode", "EUTL0009", ArrayUtil.asArray(messageCode, "messageCode : " + messageCode));
    }

    protected static synchronized void initialize() {
        DisposableUtil.addFirst(new Disposable(){

            @Override
            public void dispose() {
                initialized = false;
                loggers.clear();
                factory.releaseAll();
            }
        });
        initialized = true;
    }

    protected static LoggerAdapterFactory getLoggerAdapterFactory() {
        try {
            Class.forName("org.apache.commons.logging.LogFactory");
            return new JclLoggerAdapterFactory();
        }
        catch (Throwable ignore) {
            return new JulLoggerAdapterFactory();
        }
    }

    protected Logger(Class<?> clazz) {
        this.log = factory.getLoggerAdapter(clazz);
    }

    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    public void debug(Object message, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.log.debug(Logger.toString(message), throwable);
        }
    }

    public void debug(Object message) {
        if (this.isDebugEnabled()) {
            this.log.debug(Logger.toString(message));
        }
    }

    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    public void info(Object message, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.log.info(Logger.toString(message), throwable);
        }
    }

    public void info(Object message) {
        if (this.isInfoEnabled()) {
            this.log.info(Logger.toString(message));
        }
    }

    public void warn(Object message, Throwable throwable) {
        this.log.warn(Logger.toString(message), throwable);
    }

    public void warn(Object message) {
        this.log.warn(message.toString());
    }

    public void error(Object message, Throwable throwable) {
        this.log.error(message.toString(), throwable);
    }

    public void error(Object message) {
        this.log.error(message.toString());
    }

    public void fatal(Object message, Throwable throwable) {
        this.log.fatal(message.toString(), throwable);
    }

    public void fatal(Object message) {
        this.log.fatal(message.toString());
    }

    public void log(Throwable throwable) {
        AssertionUtil.assertArgumentNotNull("throwable", throwable);
        this.error(throwable.getMessage(), throwable);
    }

    public void log(String messageCode, Object ... args) {
        AssertionUtil.assertArgumentNotEmpty("messageCode", messageCode);
        this.log(Logger.format(messageCode, args));
    }

    public void log(LogMessage logMessage) {
        AssertionUtil.assertArgumentNotNull("logMessage", logMessage);
        this.log(logMessage, null);
    }

    public void log(LogMessage logMessage, Throwable throwable) {
        AssertionUtil.assertArgumentNotNull("logMessage", logMessage);
        LogLevel level = logMessage.getLevel();
        if (this.isEnabledFor(level)) {
            String message = logMessage.getMessage();
            switch (level) {
                case DEBUG: {
                    this.log.debug(message, throwable);
                    break;
                }
                case INFO: {
                    this.log.info(message, throwable);
                    break;
                }
                case WARN: {
                    this.log.warn(message, throwable);
                    break;
                }
                case ERROR: {
                    this.log.error(message, throwable);
                    break;
                }
                case FATAL: {
                    this.log.fatal(message, throwable);
                }
            }
        }
    }

    protected boolean isEnabledFor(LogLevel logLevel) {
        switch (logLevel) {
            case DEBUG: {
                return this.log.isDebugEnabled();
            }
            case INFO: {
                return this.log.isInfoEnabled();
            }
            case WARN: {
                return this.log.isWarnEnabled();
            }
            case ERROR: {
                return this.log.isErrorEnabled();
            }
            case FATAL: {
                return this.log.isFatalEnabled();
            }
        }
        throw new SIllegalArgumentException("logLevel", "EUTL0009", ArrayUtil.asArray(new Object[]{logLevel, logLevel}));
    }

    protected static String toString(Object message) {
        if (message == null) {
            return "null";
        }
        if (message instanceof String) {
            return (String)message;
        }
        return message.toString();
    }

    public static class LogMessage {
        protected final LogLevel level;
        protected final String message;

        public LogMessage(LogLevel level, String message) {
            AssertionUtil.assertArgumentNotNull("level", (Object)level);
            this.level = level;
            this.message = message;
        }

        public LogLevel getLevel() {
            return this.level;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static enum LogLevel {
        DEBUG,
        INFO,
        WARN,
        ERROR,
        FATAL;

    }
}

