/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import org.seasar.util.exception.IORuntimeException;
import org.seasar.util.io.CloseableUtil;
import org.seasar.util.io.InputStreamUtil;
import org.seasar.util.io.ReaderUtil;
import org.seasar.util.io.ResourceUtil;
import org.seasar.util.misc.AssertionUtil;
import org.seasar.util.net.URLUtil;
import org.seasar.util.nio.ChannelUtil;

public abstract class FileUtil {
    private static final String JIS_AUTO_DETECT = "JISAutoDetect";
    private static final String UTF8 = "UTF-8";
    protected static final int DEFAULT_BUF_SIZE = 4096;

    public static String getCanonicalPath(File file) {
        AssertionUtil.assertArgumentNotNull("file", file);
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static URL toURL(File file) {
        AssertionUtil.assertArgumentNotNull("file", file);
        try {
            return file.toURI().toURL();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(File file) {
        AssertionUtil.assertArgumentNotNull("file", file);
        FileInputStream is = InputStreamUtil.create(file);
        try {
            FileChannel channel = is.getChannel();
            ByteBuffer buffer = ByteBuffer.allocate((int)ChannelUtil.size(channel));
            ChannelUtil.read(channel, buffer);
            byte[] byArray = buffer.array();
            return byArray;
        }
        finally {
            CloseableUtil.close(is);
        }
    }

    public static String readText(String path) {
        AssertionUtil.assertArgumentNotEmpty("path", path);
        return FileUtil.readText(path, Charset.defaultCharset().name());
    }

    public static String readText(File file) {
        AssertionUtil.assertArgumentNotNull("file", file);
        return FileUtil.readText(file, Charset.defaultCharset().name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readText(String path, String encoding) {
        AssertionUtil.assertArgumentNotEmpty("path", path);
        AssertionUtil.assertArgumentNotEmpty("encoding", encoding);
        URL url = ResourceUtil.getResource(path);
        if (url.getProtocol().equals("file")) {
            return FileUtil.readText(URLUtil.toFile(url), encoding);
        }
        InputStream is = URLUtil.openStream(url);
        try {
            InputStreamReader reader = ReaderUtil.create(new BufferedInputStream(is, 4096), encoding);
            String string = FileUtil.read(reader, 4096);
            return string;
        }
        finally {
            CloseableUtil.close(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readText(File file, String encoding) {
        AssertionUtil.assertArgumentNotNull("file", file);
        AssertionUtil.assertArgumentNotEmpty("encoding", encoding);
        FileInputStream is = InputStreamUtil.create(file);
        try {
            InputStreamReader reader = ReaderUtil.create(new BufferedInputStream(is, 4096), encoding);
            String string = FileUtil.read(reader, (int)ChannelUtil.size(is.getChannel()));
            return string;
        }
        finally {
            CloseableUtil.close(is);
        }
    }

    public static String readJisAutoDetect(String path) {
        AssertionUtil.assertArgumentNotEmpty("path", path);
        return FileUtil.readText(path, JIS_AUTO_DETECT);
    }

    public static String readJisAutoDetect(File file) {
        AssertionUtil.assertArgumentNotNull("file", file);
        return FileUtil.readText(file, JIS_AUTO_DETECT);
    }

    public static String readUTF8(String path) {
        AssertionUtil.assertArgumentNotEmpty("path", path);
        return FileUtil.readText(path, UTF8);
    }

    public static String readUTF8(File file) {
        AssertionUtil.assertArgumentNotNull("file", file);
        return FileUtil.readText(file, UTF8);
    }

    protected static String read(Reader reader, int initialCapacity) {
        int bufferSize = initialCapacity;
        char[] buf = new char[bufferSize];
        int size = 0;
        try {
            int len;
            while ((len = reader.read(buf, size, bufferSize - size)) != -1) {
                if ((size += len) != bufferSize) continue;
                char[] newBuf = new char[bufferSize + initialCapacity];
                System.arraycopy(buf, 0, newBuf, 0, bufferSize);
                buf = newBuf;
                bufferSize += initialCapacity;
            }
            return new String(buf, 0, size);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }
}

