/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.exception;

import org.seasar.util.collection.ArrayUtil;
import org.seasar.util.exception.SRuntimeException;

public class ConstructorNotFoundRuntimeException
extends SRuntimeException {
    private static final long serialVersionUID = 8584662068396978822L;
    private final Class<?> targetClass;
    private final Object[] methodArgs;
    private final Class<?>[] paramTypes;

    public ConstructorNotFoundRuntimeException(Class<?> targetClass, Object[] methodArgs) {
        super("EUTL0048", ArrayUtil.asArray(targetClass.getName(), ConstructorNotFoundRuntimeException.getSignature(methodArgs)));
        this.targetClass = targetClass;
        this.methodArgs = methodArgs;
        this.paramTypes = null;
    }

    public ConstructorNotFoundRuntimeException(Class<?> targetClass, Class<?>[] paramTypes) {
        super("EUTL0048", ArrayUtil.asArray(targetClass.getName(), ConstructorNotFoundRuntimeException.getSignature(paramTypes)));
        this.targetClass = targetClass;
        this.paramTypes = paramTypes;
        this.methodArgs = null;
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public Object[] getMethodArgs() {
        return this.methodArgs;
    }

    public Class<?>[] getParamTypes() {
        return this.paramTypes;
    }

    private static String getSignature(Object ... methodArgs) {
        if (methodArgs == null || methodArgs.length == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder(100);
        for (Object arg : methodArgs) {
            if (arg != null) {
                buf.append(arg.getClass().getName());
            } else {
                buf.append("null");
            }
            buf.append(", ");
        }
        buf.setLength(buf.length() - 2);
        return new String(buf);
    }

    private static String getSignature(Class<?> ... paramTypes) {
        if (paramTypes == null || paramTypes.length == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder(100);
        for (Class<?> type : paramTypes) {
            if (type != null) {
                buf.append(type.getName());
            } else {
                buf.append("null");
            }
            buf.append(", ");
        }
        buf.setLength(buf.length() - 2);
        return buf.toString();
    }
}

