/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.jar;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.seasar.util.exception.IORuntimeException;
import org.seasar.util.io.FileUtil;
import org.seasar.util.log.Logger;
import org.seasar.util.misc.AssertionUtil;
import org.seasar.util.net.JarURLConnectionUtil;
import org.seasar.util.net.URLUtil;

public abstract class JarFileUtil {
    private static final Logger logger = Logger.getLogger(JarFileUtil.class);

    public static JarFile create(String file) {
        AssertionUtil.assertArgumentNotNull("file", file);
        try {
            return new JarFile(file);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static JarFile create(File file) {
        AssertionUtil.assertArgumentNotNull("file", file);
        try {
            return new JarFile(file);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static InputStream getInputStream(JarFile file, ZipEntry entry) {
        AssertionUtil.assertArgumentNotNull("file", file);
        AssertionUtil.assertArgumentNotNull("entry", entry);
        try {
            return file.getInputStream(entry);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static JarFile toJarFile(URL jarUrl) {
        AssertionUtil.assertArgumentNotNull("jarUrl", jarUrl);
        URLConnection con = URLUtil.openConnection(jarUrl);
        if (con instanceof JarURLConnection) {
            return JarURLConnectionUtil.getJarFile((JarURLConnection)con);
        }
        return JarFileUtil.create(new File(JarFileUtil.toJarFilePath(jarUrl)));
    }

    public static String toJarFilePath(URL jarUrl) {
        AssertionUtil.assertArgumentNotNull("jarUrl", jarUrl);
        URL nestedUrl = URLUtil.create(jarUrl.getPath());
        String nestedUrlPath = nestedUrl.getPath();
        int pos = nestedUrlPath.lastIndexOf(33);
        String jarFilePath = nestedUrlPath.substring(0, pos);
        File jarFile = new File(URLUtil.decode(jarFilePath, "UTF8"));
        return FileUtil.getCanonicalPath(jarFile);
    }

    public static void close(JarFile jarFile) {
        AssertionUtil.assertArgumentNotNull("jarFile", jarFile);
        try {
            jarFile.close();
        }
        catch (IOException e) {
            logger.log(Logger.format("EUTL0017", e.getMessage()), e);
        }
    }
}

