/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.transaction;

import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.seasar.util.exception.RollbackRuntimeException;
import org.seasar.util.exception.SystemRuntimeException;
import org.seasar.util.misc.AssertionUtil;

public abstract class TransactionUtil {
    public static int getStatus(Transaction tx) {
        AssertionUtil.assertArgumentNotNull("tx", tx);
        try {
            return tx.getStatus();
        }
        catch (SystemException e) {
            throw new SystemRuntimeException(e);
        }
    }

    public static void enlistResource(Transaction tx, XAResource xaResource) {
        AssertionUtil.assertArgumentNotNull("tx", tx);
        AssertionUtil.assertArgumentNotNull("xaResource", xaResource);
        try {
            tx.enlistResource(xaResource);
        }
        catch (SystemException e) {
            throw new SystemRuntimeException(e);
        }
        catch (RollbackException e) {
            throw new RollbackRuntimeException(e);
        }
    }

    public static void registerSynchronization(Transaction tx, Synchronization sync) {
        AssertionUtil.assertArgumentNotNull("tx", tx);
        AssertionUtil.assertArgumentNotNull("sync", sync);
        try {
            tx.registerSynchronization(sync);
        }
        catch (SystemException e) {
            throw new SystemRuntimeException(e);
        }
        catch (RollbackException e) {
            throw new RollbackRuntimeException(e);
        }
    }
}

