# Windows PowerShell
# iȂlIȁjVXeJ̓
#
# 2013/04/04 VK쐬

Set-StrictMode -Version Latest

###
### 萔`
###
$baseDir = Convert-Path $(Split-Path -Path $MyInvocation.InvocationName -Parent)
$tmpDir = $baseDir + "\tmp"
$toolDir = $baseDir
$unzipPath = $null

###
### ֐`
###

# c[B
# $srcUrl - A[JCut@CURL
# $destDir - A[JCuWJfBNg
# return - Ȃ
function U-Setup-Archive($srcUrl, $destDir, $fname = $null) {
    if ($fname -eq $null) {
        $fname = U-Get-Name -url $srcUrl
    }
    $tmpPath = U-Join-Path $tmpDir $fname
    $toolPath = U-Join-Path $destDir $fname
    if (-not $(Test-Path $tmpPath)) {
        U-Download-File -srcUrl $srcUrl -destPath $tmpPath
    }
    mkdir -Force $destDir | Out-Null
    U-Unarchive-File -srcPath $tmpPath -destDir $destDir
    return
}

# c[B
# $srcUrl - t@CURL
# $destDir - zufBNg
# return - Ȃ
function U-Setup-File($srcUrl, $destDir) {
    $fname = U-Get-Name -url $srcUrl
    $destPath = U-Join-Path $destDir $fname
    if (-not $(Test-Path $destPath)) {
        mkdir -Force $destDir | Out-Null
        U-Download-File -srcUrl $srcUrl -destPath $destPath
    }
    return
}

# A[JCut@C_E[hB
# $srcUrl - _E[hURL
# $destPath - ۑpX
# return - Ȃ
function U-Download-File($srcUrl, $destPath) {
    $webClient = New-Object System.Net.WebClient
    Write-Output "_E[hJn $srcUrl"
    $webClient.DownloadFile($srcUrl, $destPath)
    Write-Output "I"
    return
}

# ƃfBNg̃A[JCut@CWJB
# $srcPath - A[JCut@C
# $destDir - WJfBNg
# return - Ȃ
function U-Unarchive-File($srcPath, $destDir) {
    Write-Output "A[JCut@CWJJn $srcPath"
    if ($unzipPath -eq $null) {
        $sh = New-Object -ComObject Shell.Application
        $srcPathObj = $sh.NameSpace($srcPath)
        $destDirObj = $sh.NameSpace($destDir)
        $destDirObj.CopyHere($srcPathObj.Items())
    } else {
        # ㏑œWJ
        # I܂őҋ@
        Start-Process $unzipPath -ArgumentList -o, $srcPath, -d, $destDir -Wait -WindowStyle Minimized
    }
    Write-Output "I"
    return
}

# URLt@C̖O擾B
# $url - URL
# return - t@C
function U-Get-Name($url) {
    return [System.IO.Path]::GetFileName($url)
}

# pXAB
# $path1 - pX
# $path2 - pX
# return - pX
function U-Join-Path($path1, $path2) {
    return [System.IO.Path]::Combine($path1, $path2)
}

# fBNg폜B
# $dir - 폜ΏۃfBNg
# return - Ȃ
function U-Remove-Dir($dir) {
    if (Test-Path $dir) {
        Remove-Item -Force -Recurse $dir
    }
    return
}

###
### s
###

# JgfBNgݒ
Push-Location $baseDir

# ƃfBNgȂǍ쐬
mkdir -Force $tmpDir | Out-Null
mkdir -Force $toolDir | Out-Null

# GnuWin32iunzipj
$destDir = U-Join-Path $toolDir "gnuwin32"
$unzipTest = U-Join-Path $destDir "bin\unzip.exe"
if (-not $(Test-Path $unzipTest)) {
    #U-Remove-Dir $destDir
    U-Setup-Archive `
        -srcUrl "http://sourceforge.net/projects/gnuwin32/files/unzip/5.51-1/unzip-5.51-1-bin.zip" `
        -destDir $destDir
}
$unzipPath = $unzipTest

# GnuWin32iunzipȊOj
$urls = `
    "http://sourceforge.net/projects/gnuwin32/files/diffutils/2.8.7-1/diffutils-2.8.7-1-bin.zip",
    "http://sourceforge.net/projects/gnuwin32/files/diffutils/2.8.7-1/diffutils-2.8.7-1-dep.zip",
    "http://sourceforge.net/projects/gnuwin32/files/findutils/4.2.20-2/findutils-4.2.20-2-bin.zip",
    "http://sourceforge.net/projects/gnuwin32/files/findutils/4.2.20-2/findutils-4.2.20-2-dep.zip",
    "http://sourceforge.net/projects/gnuwin32/files/gawk/3.1.6-1/gawk-3.1.6-1-bin.zip",
    "http://sourceforge.net/projects/gnuwin32/files/grep/2.5.4/grep-2.5.4-bin.zip",
    "http://sourceforge.net/projects/gnuwin32/files/grep/2.5.4/grep-2.5.4-dep.zip",
    "http://sourceforge.net/projects/gnuwin32/files/gzip/1.3.12-1/gzip-1.3.12-1-bin.zip",
    "http://sourceforge.net/projects/gnuwin32/files/sed/4.2.1/sed-4.2.1-bin.zip",
    "http://sourceforge.net/projects/gnuwin32/files/sed/4.2.1/sed-4.2.1-dep.zip",
    "http://sourceforge.net/projects/gnuwin32/files/tar/1.13-1/tar-1.13-1-bin.zip",
    "http://sourceforge.net/projects/gnuwin32/files/tar/1.13-1/tar-1.13-1-dep.zip",
    "http://sourceforge.net/projects/gnuwin32/files/wget/1.11.4-1/wget-1.11.4-1-bin.zip",
    "http://sourceforge.net/projects/gnuwin32/files/wget/1.11.4-1/wget-1.11.4-1-dep.zip",
    "http://sourceforge.net/projects/gnuwin32/files/zip/3.0/zip-3.0-bin.zip",
    "http://sourceforge.net/projects/gnuwin32/files/zip/3.0/zip-3.0-dep.zip"
#"http://sourceforge.net/projects/gnuwin32/files/coreutils/5.3.0/coreutils-5.3.0-bin.zip"
#"http://sourceforge.net/projects/gnuwin32/files/coreutils/5.3.0/coreutils-5.3.0-dep.zip"
foreach($url in $urls) {
    U-Setup-Archive -srcUrl $url -destDir $destDir
}

# Ant
U-Setup-Archive `
    -srcUrl "http://ftp.kddilabs.jp/infosystems/apache/ant/binaries/apache-ant-1.9.0-bin.zip" `
    -destDir $toolDir

# Subversion
U-Setup-Archive `
    -srcUrl "http://subversion.tigris.org/files/documents/15/47914/svn-win32-1.6.6.zip" `
    -destDir $toolDir

# Jenkins
U-Setup-File `
    -srcUrl "http://mirrors.jenkins-ci.org/war/latest/jenkins.war" `
    -destDir $(U-Join-Path $toolDir "jenkins")

# JgfBNg߂
Pop-Location

exit 0
