package com.kurukurupapa.tryandroidui.listactivity;

import com.kurukurupapa.tryandroidui.R;

import android.content.Context;
import android.graphics.Typeface;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;

public class ListActivityExAdapter extends ArrayAdapter<ListActivityExDto> {
	private static final String TAG = "com.kurukurupapa.tryandroidui";

	private LayoutInflater layoutInflater = null;
	private int resourceId;

	public ListActivityExAdapter(Context context, int resourceId) {
		super(context, 0);
		this.layoutInflater = LayoutInflater.from(context);
		this.resourceId = resourceId;
	}

	/*
	 * (非 Javadoc)
	 *
	 * @see android.widget.ArrayAdapter#getView(int, android.view.View,
	 * android.view.ViewGroup)
	 */
	@Override
	public View getView(int position, View convertView, ViewGroup parent) {
		Log.d(TAG, "position=" + position + ",convertView=" + convertView
				+ ",parent=" + parent);

		// データ取得
		ListActivityExDto dto = getItem(position);

		// View取得
		View view;
		if (convertView == null) {
			// View生成
			view = layoutInflater.inflate(resourceId, null);
		} else {
			// Viewを使い回す
			view = convertView;
		}

		// 値を設定

		ImageView imageView = (ImageView) view
				.findViewById(R.id.ListRowImageView01);
		imageView.setImageResource(dto.imageId);

		TextView textView1 = (TextView) view
				.findViewById(R.id.ListRowTextView01);
		textView1.setTypeface(Typeface.DEFAULT_BOLD);
		textView1.setTextColor(dto.textColor);
		textView1.setText(dto.text1);

		TextView textView2 = (TextView) view
				.findViewById(R.id.ListRowTextView02);
		textView2.setTextColor(dto.textColor);
		textView2.setText(dto.text2);

		return view;
	}
}
