/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.text;

import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.seasar.util.misc.AssertionUtil;
import org.seasar.util.text.DecimalFormatSymbolsUtil;

public abstract class DecimalFormatUtil {
    public static String normalize(String s) {
        return DecimalFormatUtil.normalize(s, Locale.getDefault());
    }

    public static String normalize(String s, Locale locale) {
        AssertionUtil.assertArgumentNotNull("locale", locale);
        if (s == null) {
            return null;
        }
        DecimalFormatSymbols symbols = DecimalFormatSymbolsUtil.getDecimalFormatSymbols(locale);
        char decimalSep = symbols.getDecimalSeparator();
        char groupingSep = symbols.getGroupingSeparator();
        StringBuilder buf = new StringBuilder(20);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == groupingSep) continue;
            if (c == decimalSep) {
                c = '.';
            }
            buf.append(c);
        }
        return buf.toString();
    }
}

