/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.seasar.util.exception.IORuntimeException;
import org.seasar.util.io.CloseableUtil;
import org.seasar.util.io.InputStreamUtil;
import org.seasar.util.io.OutputStreamUtil;
import org.seasar.util.io.ReaderUtil;
import org.seasar.util.io.WriterUtil;
import org.seasar.util.misc.AssertionUtil;
import org.seasar.util.net.URLUtil;
import org.seasar.util.nio.ChannelUtil;

public abstract class CopyUtil {
    protected static final int DEFAULT_BUF_SIZE = 4096;

    public static int copy(InputStream in, OutputStream out) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotNull("out", out);
        if (in instanceof FileInputStream) {
            if (out instanceof FileOutputStream) {
                return CopyUtil.copyInternal((FileInputStream)in, (FileOutputStream)out);
            }
            return CopyUtil.copyInternal((FileInputStream)in, CopyUtil.wrap(out));
        }
        if (out instanceof FileOutputStream) {
            return CopyUtil.copyInternal(CopyUtil.wrap(in), (FileOutputStream)out);
        }
        return CopyUtil.copyInternal(CopyUtil.wrap(in), CopyUtil.wrap(out));
    }

    public static int copy(InputStream in, Writer out) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotNull("out", out);
        InputStreamReader is = new InputStreamReader(CopyUtil.wrap(in));
        return CopyUtil.copyInternal((Reader)is, CopyUtil.wrap(out));
    }

    public static int copy(InputStream in, String encoding, Writer out) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotEmpty("encoding", encoding);
        AssertionUtil.assertArgumentNotNull("out", out);
        InputStreamReader is = ReaderUtil.create(CopyUtil.wrap(in), encoding);
        return CopyUtil.copyInternal((Reader)is, CopyUtil.wrap(out));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(InputStream in, File out) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotNull("out", out);
        FileOutputStream os = OutputStreamUtil.create(out);
        try {
            if (in instanceof FileInputStream) {
                int n = CopyUtil.copyInternal((FileInputStream)in, os);
                return n;
            }
            int n = CopyUtil.copyInternal(CopyUtil.wrap(in), os);
            return n;
        }
        finally {
            CloseableUtil.close(os);
        }
    }

    public static int copy(InputStream in, StringBuilder out) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotNull("out", out);
        InputStreamReader is = new InputStreamReader(CopyUtil.wrap(in));
        return CopyUtil.copyInternal((Reader)is, out);
    }

    public static int copy(InputStream in, String encoding, StringBuilder out) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotEmpty("encoding", encoding);
        AssertionUtil.assertArgumentNotNull("out", out);
        InputStreamReader is = ReaderUtil.create(CopyUtil.wrap(in), encoding);
        return CopyUtil.copyInternal((Reader)is, out);
    }

    public static int copy(Reader in, OutputStream out) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotNull("out", out);
        OutputStreamWriter os = new OutputStreamWriter(CopyUtil.wrap(out));
        return CopyUtil.copyInternal(CopyUtil.wrap(in), os);
    }

    public static int copy(Reader in, OutputStream out, String encoding) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotNull("out", out);
        AssertionUtil.assertArgumentNotEmpty("encoding", encoding);
        Writer os = WriterUtil.create(CopyUtil.wrap(out), encoding);
        return CopyUtil.copyInternal(CopyUtil.wrap(in), os);
    }

    public static int copy(Reader in, Writer out) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotNull("out", out);
        return CopyUtil.copyInternal(CopyUtil.wrap(in), CopyUtil.wrap(out));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(Reader in, File out) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotNull("out", out);
        Writer os = WriterUtil.create(out);
        try {
            int n = CopyUtil.copyInternal(CopyUtil.wrap(in), CopyUtil.wrap(os));
            return n;
        }
        finally {
            CloseableUtil.close(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(Reader in, File out, String encoding) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotNull("out", out);
        AssertionUtil.assertArgumentNotEmpty("encoding", encoding);
        Writer os = WriterUtil.create(out, encoding);
        try {
            int n = CopyUtil.copyInternal(CopyUtil.wrap(in), CopyUtil.wrap(os));
            return n;
        }
        finally {
            CloseableUtil.close(os);
        }
    }

    public static int copy(Reader in, StringBuilder out) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotNull("out", out);
        return CopyUtil.copyInternal(CopyUtil.wrap(in), out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(File in, OutputStream out) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotNull("out", out);
        FileInputStream is = InputStreamUtil.create(in);
        try {
            if (out instanceof FileOutputStream) {
                int n = CopyUtil.copyInternal(is, (FileOutputStream)out);
                return n;
            }
            int n = CopyUtil.copyInternal(is, CopyUtil.wrap(out));
            return n;
        }
        finally {
            CloseableUtil.close(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(File in, Writer out) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotNull("out", out);
        Reader is = ReaderUtil.create(in);
        try {
            int n = CopyUtil.copyInternal(CopyUtil.wrap(is), CopyUtil.wrap(out));
            return n;
        }
        finally {
            CloseableUtil.close(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(File in, String encoding, Writer out) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotEmpty("encoding", encoding);
        AssertionUtil.assertArgumentNotNull("out", out);
        Reader is = ReaderUtil.create(in, encoding);
        try {
            int n = CopyUtil.copyInternal(CopyUtil.wrap(is), CopyUtil.wrap(out));
            return n;
        }
        finally {
            CloseableUtil.close(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(File in, File out) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotNull("out", out);
        FileInputStream is = InputStreamUtil.create(in);
        try {
            int n;
            FileOutputStream os = OutputStreamUtil.create(out);
            try {
                n = CopyUtil.copyInternal(is, os);
            }
            catch (Throwable throwable) {
                CloseableUtil.close(os);
                throw throwable;
            }
            CloseableUtil.close(os);
            return n;
        }
        finally {
            CloseableUtil.close(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(File in, String encoding, File out) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotEmpty("encoding", encoding);
        AssertionUtil.assertArgumentNotNull("out", out);
        Reader is = ReaderUtil.create(in, encoding);
        try {
            int n;
            Writer os = WriterUtil.create(out);
            try {
                n = CopyUtil.copyInternal(CopyUtil.wrap(is), CopyUtil.wrap(os));
            }
            catch (Throwable throwable) {
                CloseableUtil.close(os);
                throw throwable;
            }
            CloseableUtil.close(os);
            return n;
        }
        finally {
            CloseableUtil.close(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(File in, File out, String encoding) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotNull("out", out);
        AssertionUtil.assertArgumentNotEmpty("encoding", encoding);
        Reader is = ReaderUtil.create(in);
        try {
            int n;
            Writer os = WriterUtil.create(out, encoding);
            try {
                n = CopyUtil.copyInternal(CopyUtil.wrap(is), CopyUtil.wrap(os));
            }
            catch (Throwable throwable) {
                CloseableUtil.close(os);
                throw throwable;
            }
            CloseableUtil.close(os);
            return n;
        }
        finally {
            CloseableUtil.close(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(File in, String inputEncoding, File out, String outputEncoding) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotEmpty("inputEncoding", inputEncoding);
        AssertionUtil.assertArgumentNotNull("out", out);
        AssertionUtil.assertArgumentNotEmpty("outputEncoding", outputEncoding);
        Reader is = ReaderUtil.create(in, inputEncoding);
        try {
            int n;
            Writer os = WriterUtil.create(out, outputEncoding);
            try {
                n = CopyUtil.copyInternal(CopyUtil.wrap(is), CopyUtil.wrap(os));
            }
            catch (Throwable throwable) {
                CloseableUtil.close(os);
                throw throwable;
            }
            CloseableUtil.close(os);
            return n;
        }
        finally {
            CloseableUtil.close(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(File in, StringBuilder out) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotNull("out", out);
        Reader is = ReaderUtil.create(in);
        try {
            int n = CopyUtil.copyInternal(CopyUtil.wrap(is), out);
            return n;
        }
        finally {
            CloseableUtil.close(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(File in, String encoding, StringBuilder out) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotEmpty("encoding", encoding);
        AssertionUtil.assertArgumentNotNull("out", out);
        Reader is = ReaderUtil.create(in, encoding);
        try {
            int n = CopyUtil.copyInternal(CopyUtil.wrap(is), out);
            return n;
        }
        finally {
            CloseableUtil.close(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(URL in, OutputStream out) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotNull("out", out);
        InputStream is = URLUtil.openStream(in);
        try {
            if (out instanceof FileOutputStream) {
                int n = CopyUtil.copyInternal(CopyUtil.wrap(is), (FileOutputStream)out);
                return n;
            }
            int n = CopyUtil.copyInternal(CopyUtil.wrap(is), CopyUtil.wrap(out));
            return n;
        }
        finally {
            CloseableUtil.close(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(URL in, Writer out) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotNull("out", out);
        InputStream is = URLUtil.openStream(in);
        try {
            int n = CopyUtil.copyInternal((Reader)new InputStreamReader(CopyUtil.wrap(is)), CopyUtil.wrap(out));
            return n;
        }
        finally {
            CloseableUtil.close(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(URL in, String encoding, Writer out) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotEmpty("encoding", encoding);
        AssertionUtil.assertArgumentNotNull("out", out);
        InputStream is = URLUtil.openStream(in);
        try {
            int n = CopyUtil.copyInternal((Reader)ReaderUtil.create(CopyUtil.wrap(is), encoding), CopyUtil.wrap(out));
            return n;
        }
        finally {
            CloseableUtil.close(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(URL in, File out) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotNull("out", out);
        InputStream is = URLUtil.openStream(in);
        try {
            int n;
            FileOutputStream os = OutputStreamUtil.create(out);
            try {
                n = CopyUtil.copyInternal(CopyUtil.wrap(is), os);
            }
            catch (Throwable throwable) {
                CloseableUtil.close(os);
                throw throwable;
            }
            CloseableUtil.close(os);
            return n;
        }
        finally {
            CloseableUtil.close(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(URL in, String encoding, File out) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotEmpty("encoding", encoding);
        AssertionUtil.assertArgumentNotNull("out", out);
        InputStream is = URLUtil.openStream(in);
        try {
            int n;
            Writer os = WriterUtil.create(out);
            try {
                n = CopyUtil.copyInternal((Reader)ReaderUtil.create(CopyUtil.wrap(is), encoding), CopyUtil.wrap(os));
            }
            catch (Throwable throwable) {
                CloseableUtil.close(os);
                throw throwable;
            }
            CloseableUtil.close(os);
            return n;
        }
        finally {
            CloseableUtil.close(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(URL in, File out, String encoding) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotNull("out", out);
        AssertionUtil.assertArgumentNotEmpty("encoding", encoding);
        InputStream is = URLUtil.openStream(in);
        try {
            int n;
            Writer os = WriterUtil.create(out, encoding);
            try {
                n = CopyUtil.copyInternal((Reader)new InputStreamReader(CopyUtil.wrap(is)), CopyUtil.wrap(os));
            }
            catch (Throwable throwable) {
                CloseableUtil.close(os);
                throw throwable;
            }
            CloseableUtil.close(os);
            return n;
        }
        finally {
            CloseableUtil.close(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(URL in, String inputEncoding, File out, String outputEncoding) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotEmpty("inputEncoding", inputEncoding);
        AssertionUtil.assertArgumentNotNull("out", out);
        AssertionUtil.assertArgumentNotEmpty("outputEncoding", outputEncoding);
        InputStream is = URLUtil.openStream(in);
        try {
            int n;
            Writer os = WriterUtil.create(out, outputEncoding);
            try {
                n = CopyUtil.copyInternal((Reader)ReaderUtil.create(CopyUtil.wrap(is), inputEncoding), CopyUtil.wrap(os));
            }
            catch (Throwable throwable) {
                CloseableUtil.close(os);
                throw throwable;
            }
            CloseableUtil.close(os);
            return n;
        }
        finally {
            CloseableUtil.close(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(URL in, StringBuilder out) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotNull("out", out);
        InputStream is = URLUtil.openStream(in);
        try {
            int n = CopyUtil.copyInternal((Reader)new InputStreamReader(CopyUtil.wrap(is)), out);
            return n;
        }
        finally {
            CloseableUtil.close(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(URL in, String encoding, StringBuilder out) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotEmpty("encoding", encoding);
        AssertionUtil.assertArgumentNotNull("out", out);
        InputStream is = URLUtil.openStream(in);
        try {
            int n = CopyUtil.copyInternal((Reader)ReaderUtil.create(CopyUtil.wrap(is), encoding), out);
            return n;
        }
        finally {
            CloseableUtil.close(is);
        }
    }

    public static int copy(byte[] in, OutputStream out) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotNull("out", out);
        ByteArrayInputStream is = new ByteArrayInputStream(in);
        if (out instanceof FileOutputStream) {
            return CopyUtil.copyInternal((InputStream)is, (FileOutputStream)out);
        }
        return CopyUtil.copyInternal((InputStream)is, CopyUtil.wrap(out));
    }

    public static int copy(byte[] in, Writer out) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotNull("out", out);
        InputStreamReader is = new InputStreamReader(new ByteArrayInputStream(in));
        return CopyUtil.copyInternal((Reader)is, CopyUtil.wrap(out));
    }

    public static int copy(byte[] in, String encoding, Writer out) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotEmpty("encoding", encoding);
        AssertionUtil.assertArgumentNotNull("out", out);
        InputStreamReader is = ReaderUtil.create(new ByteArrayInputStream(in), encoding);
        return CopyUtil.copyInternal((Reader)is, CopyUtil.wrap(out));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(byte[] in, File out) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotNull("out", out);
        FileOutputStream os = OutputStreamUtil.create(out);
        try {
            FileChannel channel = os.getChannel();
            ByteBuffer buffer = ByteBuffer.wrap(in);
            int n = ChannelUtil.write(channel, buffer);
            return n;
        }
        finally {
            CloseableUtil.close(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(byte[] in, String encoding, File out) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotEmpty("encoding", encoding);
        AssertionUtil.assertArgumentNotNull("out", out);
        InputStreamReader is = ReaderUtil.create(new ByteArrayInputStream(in), encoding);
        Writer os = WriterUtil.create(out);
        try {
            int n = CopyUtil.copyInternal((Reader)is, CopyUtil.wrap(os));
            return n;
        }
        finally {
            CloseableUtil.close(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(byte[] in, File out, String encoding) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotNull("out", out);
        AssertionUtil.assertArgumentNotEmpty("encoding", encoding);
        InputStreamReader is = new InputStreamReader(new ByteArrayInputStream(in));
        Writer os = WriterUtil.create(out, encoding);
        try {
            int n = CopyUtil.copyInternal((Reader)is, CopyUtil.wrap(os));
            return n;
        }
        finally {
            CloseableUtil.close(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(byte[] in, String inputEncoding, File out, String outputEncoding) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotEmpty("inputEncoding", inputEncoding);
        AssertionUtil.assertArgumentNotNull("out", out);
        AssertionUtil.assertArgumentNotEmpty("outputEncoding", outputEncoding);
        InputStreamReader is = ReaderUtil.create(new ByteArrayInputStream(in), inputEncoding);
        Writer os = WriterUtil.create(out, outputEncoding);
        try {
            int n = CopyUtil.copyInternal((Reader)is, CopyUtil.wrap(os));
            return n;
        }
        finally {
            CloseableUtil.close(os);
        }
    }

    public static int copy(byte[] in, StringBuilder out) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotNull("out", out);
        InputStreamReader is = new InputStreamReader(new ByteArrayInputStream(in));
        return CopyUtil.copyInternal((Reader)is, out);
    }

    public static int copy(byte[] in, String encoding, StringBuilder out) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotEmpty("encoding", encoding);
        AssertionUtil.assertArgumentNotNull("out", out);
        InputStreamReader is = ReaderUtil.create(new ByteArrayInputStream(in), encoding);
        return CopyUtil.copyInternal((Reader)is, out);
    }

    public static int copy(String in, OutputStream out) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotNull("out", out);
        OutputStreamWriter os = new OutputStreamWriter(CopyUtil.wrap(out));
        return CopyUtil.copyInternal((Reader)new StringReader(in), os);
    }

    public static int copy(String in, OutputStream out, String encoding) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotNull("out", out);
        AssertionUtil.assertArgumentNotEmpty("encoding", encoding);
        Writer os = WriterUtil.create(CopyUtil.wrap(out), encoding);
        return CopyUtil.copyInternal((Reader)new StringReader(in), os);
    }

    public static int copy(String in, Writer out) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotNull("out", out);
        return CopyUtil.copyInternal((Reader)new StringReader(in), CopyUtil.wrap(out));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(String in, File out) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotNull("out", out);
        Writer os = WriterUtil.create(out);
        try {
            int n = CopyUtil.copyInternal((Reader)new StringReader(in), CopyUtil.wrap(os));
            return n;
        }
        finally {
            CloseableUtil.close(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(String in, File out, String encoding) {
        AssertionUtil.assertArgumentNotNull("in", in);
        AssertionUtil.assertArgumentNotNull("out", out);
        AssertionUtil.assertArgumentNotEmpty("encoding", encoding);
        Writer os = WriterUtil.create(out, encoding);
        try {
            int n = CopyUtil.copyInternal((Reader)new StringReader(in), CopyUtil.wrap(os));
            return n;
        }
        finally {
            CloseableUtil.close(os);
        }
    }

    protected static int copyInternal(InputStream in, OutputStream out) {
        try {
            int len;
            byte[] buf = new byte[4096];
            int amount = 0;
            while ((len = in.read(buf)) != -1) {
                out.write(buf, 0, len);
                amount += len;
            }
            out.flush();
            return amount;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    protected static int copyInternal(FileInputStream in, OutputStream out) {
        try {
            int len;
            FileChannel channel = in.getChannel();
            ByteBuffer buffer = ByteBuffer.allocate(4096);
            byte[] buf = buffer.array();
            int amount = 0;
            while ((len = ChannelUtil.read(channel, buffer, amount)) != -1) {
                out.write(buf, 0, len);
                buffer.clear();
                amount += len;
            }
            out.flush();
            return amount;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    protected static int copyInternal(InputStream in, FileOutputStream out) {
        try {
            int len;
            FileChannel channel = out.getChannel();
            ByteBuffer buffer = ByteBuffer.allocate(4096);
            byte[] buf = buffer.array();
            int amount = 0;
            while ((len = in.read(buf)) != -1) {
                channel.write(buffer, amount);
                buffer.clear();
                amount += len;
            }
            out.flush();
            return amount;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    protected static int copyInternal(FileInputStream in, FileOutputStream out) {
        FileChannel ic = in.getChannel();
        FileChannel oc = out.getChannel();
        return (int)ChannelUtil.transfer(ic, oc);
    }

    protected static int copyInternal(Reader in, Writer out) {
        try {
            int len;
            char[] buf = new char[4096];
            int amount = 0;
            while ((len = in.read(buf)) != -1) {
                out.write(buf, 0, len);
                amount += len;
            }
            out.flush();
            return amount;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    protected static int copyInternal(Reader in, StringBuilder out) {
        try {
            int len;
            char[] buf = new char[4096];
            int amount = 0;
            while ((len = in.read(buf)) != -1) {
                out.append(buf, 0, len);
                amount += len;
            }
            return amount;
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    protected static InputStream wrap(InputStream is) {
        if (is instanceof BufferedInputStream) {
            return is;
        }
        if (is instanceof ByteArrayInputStream) {
            return is;
        }
        return new BufferedInputStream(is, 4096);
    }

    protected static OutputStream wrap(OutputStream os) {
        if (os instanceof BufferedOutputStream) {
            return os;
        }
        if (os instanceof ByteArrayOutputStream) {
            return os;
        }
        return new BufferedOutputStream(os, 4096);
    }

    protected static Reader wrap(Reader reader) {
        if (reader instanceof BufferedReader) {
            return reader;
        }
        if (reader instanceof StringReader) {
            return reader;
        }
        return new BufferedReader(reader, 4096);
    }

    protected static Writer wrap(Writer writer) {
        if (writer instanceof BufferedWriter) {
            return writer;
        }
        if (writer instanceof StringWriter) {
            return writer;
        }
        return new BufferedWriter(writer, 4096);
    }
}

