package com.kurukurupapa.tryandroiddb.db002;

import java.util.List;

import com.kurukurupapa.tryandroid.fw.DbHelper;
import com.kurukurupapa.tryandroid.fw.util.ActivityUtil;
import com.kurukurupapa.tryandroid.fw.util.LogUtil;
import com.kurukurupapa.tryandroid.fw.util.StringUtil;

import android.app.Activity;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;

public class Db002Activity extends Activity {
	public EditText dbEditText;
	public Button dbInsertButton;
	public Button dbUpdateButton;
	public Button dbDeleteButton;
	public Button dbCreateButton;
	public Button dbDropButton;
	public TextView dbTextView;
	public DbHelper dbHelper;

	private Record record;

	/*
	 * (非 Javadoc)
	 *
	 * @see android.app.Activity#onCreate(android.os.Bundle)
	 */
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		LogUtil.called();
		super.onCreate(savedInstanceState);

		// フィールド設定
		ActivityUtil.initializeActivity(this);

		// DB設定
		// BaseActivityクラスで初期設定してくれているが、テーブル作成・削除の設定は、
		// してくれていないので、再設定する。
		dbHelper = new DbHelper(this, new Class<?>[] { Record.class });

		// 初期表示処理
		try {
			findData(false);
		} catch (Exception e) {
			LogUtil.e("Error", e);
		}
	}

	private void findData(boolean dropFlag) {
		// DB検索
		String text = null;
		List<Record> list = null;
		if (!dropFlag) {
			list = dbHelper.findAll(Record.class, "id");
			text = StringUtil.join(list, "\n");
		}
		LogUtil.d("text=\n" + text);

		// 画面表示
		dbTextView.setText(text);
		if (list == null || list.size() <= 0) {
			record = null;
		} else {
			record = list.get(list.size() - 1);
		}
		dbInsertButton.setEnabled(!dropFlag);
		dbUpdateButton.setEnabled(record != null);
		dbDeleteButton.setEnabled(record != null);
		dbCreateButton.setEnabled(dropFlag);
		dbDropButton.setEnabled(!dropFlag);
	}

	public void dbCreateButton_OnClick(View view) {
		// テーブル作成
		dbHelper.createTables();
		// 再表示
		findData(false);
	}

	public void dbDropButton_OnClick(View view) {
		// テーブル削除
		dbHelper.dropTables();
		// 再表示
		findData(true);
	}

	public void dbInsertButton_OnClick(View view) {
		// レコード挿入
		record = new Record();
		record.timestamp = System.currentTimeMillis();
		record.text = dbEditText.getText().toString();
		dbHelper.insert(record);
		// 再表示
		findData(false);
	}

	public void dbUpdateButton_OnClick(View view) {
		// レコード更新
		record.text = dbEditText.getText().toString();
		dbHelper.update(record);
		// 再表示
		findData(false);
	}

	public void dbDeleteButton_OnClick(View view) {
		// レコード削除
		dbHelper.delete(record);
		// 再表示
		findData(false);
	}

}
