/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.aptina.commons.source;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Formatter;
import java.util.Locale;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;
import org.seasar.aptina.commons.message.EnumMessageFormatter;
import org.seasar.aptina.commons.util.IOUtils;
import org.seasar.aptina.commons.util.VersionUtils;

public abstract class SimpleSourceGenerator<T extends Enum<T>> {
    protected static final char[] SPACES = new char[100];
    protected final ProcessingEnvironment env;
    protected final StringBuilder buf = new StringBuilder(1024);
    protected final Formatter formatter;
    protected final EnumMessageFormatter<T> enumFormatter;
    protected int depth;

    public SimpleSourceGenerator(ProcessingEnvironment env, Class<T> enumClass) {
        this.env = env;
        Locale locale = env.getLocale();
        this.formatter = new Formatter(this.buf, locale);
        this.enumFormatter = new EnumMessageFormatter<T>(enumClass, this.buf, locale);
    }

    public String toString() {
        return new String(this.buf);
    }

    protected void reset() {
        this.buf.setLength(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(String className, TypeElement originalElement) throws IOException {
        Filer filer = this.env.getFiler();
        JavaFileObject sourceFile = filer.createSourceFile(className, originalElement);
        BufferedWriter writer = new BufferedWriter(sourceFile.openWriter());
        try {
            writer.write(new String(this.buf));
        }
        finally {
            IOUtils.closeSilently(writer);
        }
    }

    protected void enter() {
        ++this.depth;
    }

    protected void leave() {
        --this.depth;
    }

    protected void indent() {
        this.indent(this.depth * 4);
    }

    protected void indent(int spaces) {
        for (int i = spaces; i > 0; i -= SPACES.length) {
            this.buf.append(SPACES, 0, i > SPACES.length ? SPACES.length : i);
        }
    }

    protected void printf(String format, Object ... args) {
        this.indent();
        this.formatter.format(format, args);
    }

    protected void printf(T code, Object ... args) {
        this.indent();
        this.enumFormatter.format(code, args);
    }

    protected void printJavadoc(String comment) {
        if (comment == null || comment.isEmpty()) {
            return;
        }
        this.printf("/**%n", new Object[0]);
        BufferedReader reader = new BufferedReader(new StringReader(comment));
        try {
            String line = reader.readLine();
            if (!line.isEmpty()) {
                this.printf(" *%1$s%n", new Object[]{line});
            }
            while ((line = reader.readLine()) != null) {
                this.printf(" *%1$s%n", new Object[]{line});
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.printf(" */%n", new Object[0]);
    }

    protected void printJavadoc(T code, Object ... args) {
        this.printJavadoc(this.enumFormatter.getMessage(code, args));
    }

    protected void printGeneratedAnnotation(String productName, String groupId, String artifactId) {
        this.printf("@javax.annotation.Generated({\"%1$s\", \"%2$s\", \"%3$s\", \"%4$s\"})%n", new Object[]{productName, groupId, artifactId, VersionUtils.getVersion(groupId, artifactId, "DEV")});
    }

    static {
        Arrays.fill(SPACES, ' ');
    }
}

