/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.collection;

import java.util.Iterator;
import org.seasar.util.exception.SNoSuchElementException;
import org.seasar.util.exception.SUnsupportedOperationException;
import org.seasar.util.misc.AssertionUtil;

public class MultiIterator<E>
implements Iterator<E> {
    protected final Iterator<E>[] iterators;
    protected int index;

    public static <E> Iterable<E> iterable(Iterable<E> ... iterables) {
        AssertionUtil.assertArgumentNotNull("iterables", iterables);
        Iterator[] iterators = new Iterator[iterables.length];
        for (int i = 0; i < iterables.length; ++i) {
            iterators[i] = iterables[i].iterator();
        }
        return MultiIterator.iterable(iterators);
    }

    public static <E> Iterable<E> iterable(final Iterator<E> ... iterators) {
        AssertionUtil.assertArgumentNotNull("iterators", iterators);
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return new MultiIterator(iterators);
            }
        };
    }

    public MultiIterator(Iterator<E> ... iterators) {
        AssertionUtil.assertArgumentNotNull("iterators", iterators);
        this.iterators = iterators;
    }

    @Override
    public boolean hasNext() {
        while (this.index < this.iterators.length) {
            if (this.iterators[this.index].hasNext()) {
                return true;
            }
            ++this.index;
        }
        return false;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new SNoSuchElementException();
        }
        return this.iterators[this.index].next();
    }

    @Override
    public void remove() {
        throw new SUnsupportedOperationException("remove");
    }
}

