package com.kurukurupapa.tryandroid.fw.util;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;

import junit.framework.TestCase;

public class DateUtilTest extends TestCase {
	private static final long MILLIS_PER_SECOND = 1000;
	private static final long MILLIS_PER_MINUTE = 60 * MILLIS_PER_SECOND;
	private static final long MILLIS_PER_HOUR = 60 * MILLIS_PER_MINUTE;
	private static final long MILLIS_PER_DAY = 24 * MILLIS_PER_HOUR;
	private static final long MILLIS_PER_YEAR = 365 * MILLIS_PER_DAY;

	protected void setUp() throws Exception {
		super.setUp();
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testFormatDurationTime() {
		String result;

		result = DateUtil.formatDurationTime(12 * MILLIS_PER_HOUR + 34
				* MILLIS_PER_MINUTE + 56 * MILLIS_PER_SECOND);
		assertEquals("12時間34分56秒", result);

		result = DateUtil.formatDurationTime(1 * MILLIS_PER_HOUR + 2
				* MILLIS_PER_MINUTE + 3 * MILLIS_PER_SECOND);
		assertEquals("1時間2分3秒", result);

		result = DateUtil.formatDurationTime(MILLIS_PER_HOUR);
		assertEquals("1時間0分0秒", result);

		result = DateUtil.formatDurationTime(MILLIS_PER_MINUTE);
		assertEquals("1分0秒", result);

		result = DateUtil.formatDurationTime(MILLIS_PER_SECOND);
		assertEquals("1秒", result);
	}

	public void testFormatShortDurationTime() {
		String result;

		result = DateUtil.formatShortDurationTime(12 * MILLIS_PER_HOUR + 34
				* MILLIS_PER_MINUTE + 56 * MILLIS_PER_SECOND);
		assertEquals("12h34m", result);

		result = DateUtil.formatShortDurationTime(1 * MILLIS_PER_HOUR + 2
				* MILLIS_PER_MINUTE + 3 * MILLIS_PER_SECOND);
		assertEquals("1h2m", result);

		result = DateUtil.formatShortDurationTime(MILLIS_PER_HOUR);
		assertEquals("1h0m", result);

		result = DateUtil.formatShortDurationTime(MILLIS_PER_MINUTE);
		assertEquals("1m", result);

		result = DateUtil.formatShortDurationTime(MILLIS_PER_SECOND);
		assertEquals("0m", result);

	}

	public void testParseDateTime() throws ParseException {
		Date date = DateUtil.parseDateTime("2012/10/27 14:06:12");
		assertEquals(2012 - 1900, date.getYear());
		assertEquals(10 - 1, date.getMonth());
		assertEquals(27, date.getDate());
		assertEquals(14, date.getHours());
		assertEquals(6, date.getMinutes());
		assertEquals(12, date.getSeconds());
	}

	public void testFormatDateTimeCalendar() {
		Calendar calendar = Calendar.getInstance();
		calendar.setTimeInMillis( //
		(1971 - 1970) * MILLIS_PER_YEAR //
				+ (40 - 1) * MILLIS_PER_DAY //
				+ (1 - 9) * MILLIS_PER_HOUR //
				+ 2 * MILLIS_PER_MINUTE //
				+ 3 * MILLIS_PER_SECOND);
		String result = DateUtil.formatDateTime(calendar);
		assertEquals("1971/02/09 01:02:03", result);
	}

	public void testFormatDateTimeDate() {
		Date date = new Date( //
				(1971 - 1970) * MILLIS_PER_YEAR //
						+ (40 - 1) * MILLIS_PER_DAY //
						+ (1 - 9) * MILLIS_PER_HOUR //
						+ 2 * MILLIS_PER_MINUTE //
						+ 3 * MILLIS_PER_SECOND);
		String result = DateUtil.formatDateTime(date);
		assertEquals("1971/02/09 01:02:03", result);
	}

	public void testFormatDateTimeLong() {
		String result = DateUtil.formatDateTime( //
				(1971 - 1970) * MILLIS_PER_YEAR //
						+ (40 - 1) * MILLIS_PER_DAY //
						+ (1 - 9) * MILLIS_PER_HOUR //
						+ 2 * MILLIS_PER_MINUTE //
						+ 3 * MILLIS_PER_SECOND);
		assertEquals("1971/02/09 01:02:03", result);
	}

}
