package com.kurukurupapa.tryandroid.fw;

import com.kurukurupapa.tryandroid.fw.util.LogUtil;

import android.app.ProgressDialog;
import android.content.Context;
import android.os.AsyncTask;

public abstract class AsyncTaskWithProgressDialog<Params, Progress, Result>
		extends AsyncTask<Params, Progress, Result> {

	protected Context context;
	protected ProgressDialog progressDialog;
	private String progressMsg;

	public AsyncTaskWithProgressDialog(Context context) {
		this(context, "少々お待ちください");
	}

	public AsyncTaskWithProgressDialog(Context context, String progressMsg) {
		this.context = context;
		this.progressMsg = progressMsg;
	}

	/**
	 * スレッド開始前処理<br>
	 * UIスレッドでダイアログを表示する
	 */
	@Override
	protected void onPreExecute() {
		super.onPreExecute();
		LogUtil.called();

		// ProgressDialog作成
		progressDialog = new ProgressDialog(context);
		progressDialog.setMessage(progressMsg);
		// // 処理時間は不確定
		// progressDialog.setIndeterminate(true);

		// ProgressDialog表示
		progressDialog.show();
	}

	/**
	 * スレッド完了後処理<br>
	 *
	 * @param result
	 */
	@Override
	protected void onPostExecute(Result result) {
		LogUtil.called();

		// 処理中ダイアログをクローズ
		progressDialog.dismiss();
	}
}
