package com.kurukurupapa.tryandroid.apt002;

import org.seasar.util.lang.StringUtil;

import com.kurukurupapa.tryandroid.apt.util.MiniStringUtil;

public class FieldData {
	private String srcType;
	private String srcName;
	private String dbType;
	private String dbName;
	private String dbInfo;

	/**
	 * コンストラクタ
	 */
	public FieldData() {
	}

	/**
	 * コンストラクタ
	 */
	public FieldData(String type, String name) {
		setSrcType(type);
		setSrcName(name);
	}

	/**
	 * フィールドの型を設定
	 */
	public void setSrcType(String srcType) {
		// srcTypeを設定する。
		if ("java.lang.String".equals(srcType)) {
			srcType = "String";
		}
		this.srcType = StringUtil.capitalize(srcType);

		// srcTypeに依存して、dbTypeを決定する。
		if (srcType.equals("short") || srcType.equals("int")
				|| srcType.equals("long")) {
			this.dbType = "integer";
		} else if (srcType.equals("float") || srcType.equals("double")) {
			this.dbType = "real";
		} else if (srcType.equals("String")) {
			this.dbType = "text";
		} else {
			throw new RuntimeException("不明な型です。type=" + srcType);
		}
	}

	/**
	 * フィールドの名前を設定
	 */
	public void setSrcName(String srcName) {
		this.srcName = StringUtil.capitalize(srcName);
		this.dbName = MiniStringUtil.decamelizeAsLowerCase(srcName);
		if (srcName.equals("id")) {
			this.dbInfo = "primary key autoincrement";
		} else {
			this.dbInfo = "not null";
		}
	}

	public String getSrcType() {
		return srcType;
	}

	public String getSrcName() {
		return srcName;
	}

	public String getDbName() {
		return dbName;
	}

	public String getDbType() {
		return dbType;
	}

	public String getDbInfo() {
		return dbInfo;
	}

}
