/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.collection;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.seasar.util.exception.SNoSuchElementException;
import org.seasar.util.misc.AssertionUtil;

public class ArrayMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Cloneable,
Externalizable {
    private static final long serialVersionUID = 1L;
    public static final int INITIAL_CAPACITY = 17;
    public static final float LOAD_FACTOR = 0.75f;
    protected transient int threshold;
    protected transient Entry<K, V>[] mapTable;
    protected transient Entry<K, V>[] listTable;
    protected transient int size = 0;
    protected transient Set<? extends Map.Entry<K, V>> entrySet = null;

    public ArrayMap() {
        this(17);
    }

    public ArrayMap(int initialCapacity) {
        if (initialCapacity <= 0) {
            initialCapacity = 17;
        }
        this.mapTable = new Entry[initialCapacity];
        this.listTable = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * 0.75f);
    }

    public ArrayMap(Map<? extends K, ? extends V> map) {
        this((int)((float)map.size() / 0.75f) + 1);
        this.putAll(map);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.indexOf(value) >= 0;
    }

    public int indexOf(Object value) {
        if (value != null) {
            for (int i = 0; i < this.size; ++i) {
                if (!value.equals(this.listTable[i].value)) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                if (this.listTable[i].value != null) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean containsKey(Object key) {
        Entry<K, V>[] tbl = this.mapTable;
        if (key != null) {
            int hashCode = key.hashCode();
            int index = (hashCode & Integer.MAX_VALUE) % tbl.length;
            Entry<K, V> e = tbl[index];
            while (e != null) {
                if (e.hashCode == hashCode && key.equals(e.key)) {
                    return true;
                }
                e = e.next;
            }
        } else {
            Entry<K, V> e = tbl[0];
            while (e != null) {
                if (e.key == null) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    @Override
    public V get(Object key) {
        Entry<K, V>[] tbl = this.mapTable;
        if (key != null) {
            int hashCode = key.hashCode();
            int index = (hashCode & Integer.MAX_VALUE) % tbl.length;
            Entry<K, V> e = tbl[index];
            while (e != null) {
                if (e.hashCode == hashCode && key.equals(e.key)) {
                    return e.value;
                }
                e = e.next;
            }
        } else {
            Entry<K, V> e = tbl[0];
            while (e != null) {
                if (e.key == null) {
                    return e.value;
                }
                e = e.next;
            }
        }
        return null;
    }

    public V getAt(int index) {
        return this.getEntryAt(index).getValue();
    }

    public K getKeyAt(int index) {
        return this.getEntryAt(index).getKey();
    }

    public Map.Entry<K, V> getEntryAt(int index) {
        AssertionUtil.assertIndex(index < this.size, "Index:" + index + ", Size:" + this.size);
        return this.listTable[index];
    }

    @Override
    public V put(K key, V value) {
        Entry<K, V> e;
        int hashCode = 0;
        int index = 0;
        if (key != null) {
            hashCode = key.hashCode();
            index = (hashCode & Integer.MAX_VALUE) % this.mapTable.length;
            e = this.mapTable[index];
            while (e != null) {
                if (e.hashCode == hashCode && key.equals(e.key)) {
                    return this.swapValue(e, value);
                }
                e = e.next;
            }
        } else {
            e = this.mapTable[0];
            while (e != null) {
                if (e.key == null) {
                    return this.swapValue(e, value);
                }
                e = e.next;
            }
        }
        this.ensureCapacity();
        index = (hashCode & Integer.MAX_VALUE) % this.mapTable.length;
        this.mapTable[index] = e = new Entry<K, V>(hashCode, key, value, this.mapTable[index]);
        this.listTable[this.size++] = e;
        return null;
    }

    public void setAt(int index, V value) {
        this.getEntryAt(index).setValue(value);
    }

    @Override
    public V remove(Object key) {
        Entry<K, V> e = this.removeMap(key);
        if (e != null) {
            Object value = e.value;
            this.removeList(this.entryIndexOf(e));
            e.clear();
            return value;
        }
        return null;
    }

    public V removeAt(int index) {
        Entry<K, V> e = this.removeList(index);
        Object value = e.value;
        this.removeMap(e.key);
        e.clear();
        return value;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        int i;
        for (i = 0; i < this.mapTable.length; ++i) {
            this.mapTable[i] = null;
        }
        for (i = 0; i < this.listTable.length; ++i) {
            this.listTable[i] = null;
        }
        this.size = 0;
    }

    public Object[] toArray() {
        Object[] array = new Object[this.size];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.getAt(i);
        }
        return array;
    }

    public V[] toArray(V[] proto) {
        V[] array = proto.length >= this.size ? proto : (Object[])Array.newInstance(proto.getClass().getComponentType(), this.size);
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.getAt(i);
        }
        if (array.length > this.size) {
            array[this.size] = null;
        }
        return array;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof ArrayMap)) {
            return false;
        }
        ArrayMap e = (ArrayMap)o;
        if (this.size != e.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.listTable[i].equals(e.listTable[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (int i = 0; i < this.size; ++i) {
            h += this.listTable[i].hashCode();
        }
        return h;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Entry<K, V>>(){

                @Override
                public Iterator<Entry<K, V>> iterator() {
                    return new ArrayMapIterator();
                }

                @Override
                public boolean contains(Object o) {
                    Entry entry = (Entry)o;
                    int index = (entry.hashCode & Integer.MAX_VALUE) % ArrayMap.this.mapTable.length;
                    Entry e = ArrayMap.this.mapTable[index];
                    while (e != null) {
                        if (e.equals(entry)) {
                            return true;
                        }
                        e = e.next;
                    }
                    return false;
                }

                @Override
                public boolean remove(Object o) {
                    if (!(o instanceof Entry)) {
                        return false;
                    }
                    Entry entry = (Entry)o;
                    return ArrayMap.this.remove(entry.key) != null;
                }

                @Override
                public int size() {
                    return ArrayMap.this.size;
                }

                @Override
                public void clear() {
                    ArrayMap.this.clear();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.listTable.length);
        out.writeInt(this.size);
        for (int i = 0; i < this.size; ++i) {
            out.writeObject(this.listTable[i].key);
            out.writeObject(this.listTable[i].value);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int num = in.readInt();
        this.mapTable = new Entry[num];
        this.listTable = new Entry[num];
        this.threshold = (int)((float)num * 0.75f);
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            Object key = in.readObject();
            Object value = in.readObject();
            this.put(key, value);
        }
    }

    @Override
    public Object clone() {
        ArrayMap<K, V> copy = new ArrayMap<K, V>();
        copy.threshold = this.threshold;
        copy.mapTable = Arrays.copyOf(this.mapTable, this.size);
        copy.listTable = Arrays.copyOf(this.listTable, this.size);
        copy.size = this.size;
        return copy;
    }

    protected int entryIndexOf(Entry<K, V> entry) {
        for (int i = 0; i < this.size; ++i) {
            if (this.listTable[i] != entry) continue;
            return i;
        }
        return -1;
    }

    protected Entry<K, V> removeMap(Object key) {
        int hashCode = 0;
        int index = 0;
        if (key != null) {
            hashCode = key.hashCode();
            index = (hashCode & Integer.MAX_VALUE) % this.mapTable.length;
            Entry<K, V> e = this.mapTable[index];
            Entry<K, V> prev = null;
            while (e != null) {
                if (e.hashCode == hashCode && key.equals(e.key)) {
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        this.mapTable[index] = e.next;
                    }
                    return e;
                }
                prev = e;
                e = e.next;
            }
        } else {
            Entry<K, V> e = this.mapTable[index];
            Entry<K, V> prev = null;
            while (e != null) {
                if (e.hashCode == hashCode && e.key == null) {
                    if (prev != null) {
                        prev.next = e.next;
                    } else {
                        this.mapTable[index] = e.next;
                    }
                    return e;
                }
                prev = e;
                e = e.next;
            }
        }
        return null;
    }

    protected Entry<K, V> removeList(int index) {
        Entry<K, V> e = this.listTable[index];
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.listTable, index + 1, this.listTable, index, numMoved);
        }
        this.listTable[--this.size] = null;
        return e;
    }

    protected void ensureCapacity() {
        if (this.size >= this.threshold) {
            Entry<K, V>[] oldTable = this.listTable;
            int newCapacity = oldTable.length * 2 + 1;
            Entry[] newMapTable = new Entry[newCapacity];
            Entry[] newListTable = new Entry[newCapacity];
            this.threshold = (int)((float)newCapacity * 0.75f);
            System.arraycopy(oldTable, 0, newListTable, 0, this.size);
            for (int i = 0; i < this.size; ++i) {
                Entry<K, V> old = oldTable[i];
                int index = (old.hashCode & Integer.MAX_VALUE) % newCapacity;
                Entry<K, V> e = old;
                old = old.next;
                e.next = newMapTable[index];
                newMapTable[index] = e;
            }
            this.mapTable = newMapTable;
            this.listTable = newListTable;
        }
    }

    protected V swapValue(Entry<K, V> entry, V value) {
        Object old = entry.value;
        entry.value = value;
        return old;
    }

    protected static class Entry<K, V>
    implements Map.Entry<K, V>,
    Externalizable {
        private static final long serialVersionUID = -6625980241350717177L;
        protected transient int hashCode;
        protected transient K key;
        protected transient V value;
        protected transient Entry<K, V> next;

        public Entry() {
        }

        public Entry(int hashCode, K key, V value, Entry<K, V> next) {
            this.hashCode = hashCode;
            this.key = key;
            this.value = value;
            this.next = next;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = value;
            this.value = value;
            return oldValue;
        }

        public void clear() {
            this.key = null;
            this.value = null;
            this.next = null;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            return (this.key != null ? this.key.equals(e.key) : e.key == null) && (this.value != null ? this.value.equals(e.value) : e.value == null);
        }

        @Override
        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        @Override
        public void writeExternal(ObjectOutput s) throws IOException {
            s.writeInt(this.hashCode);
            s.writeObject(this.key);
            s.writeObject(this.value);
            s.writeObject(this.next);
        }

        @Override
        public void readExternal(ObjectInput s) throws IOException, ClassNotFoundException {
            this.hashCode = s.readInt();
            this.key = s.readObject();
            this.value = s.readObject();
            this.next = (Entry)s.readObject();
        }
    }

    protected class ArrayMapIterator
    implements Iterator<Entry<K, V>> {
        protected int current = 0;
        protected int last = -1;

        protected ArrayMapIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.current != ArrayMap.this.size;
        }

        @Override
        public Entry<K, V> next() {
            try {
                Entry n = ArrayMap.this.listTable[this.current];
                this.last = this.current++;
                return n;
            }
            catch (IndexOutOfBoundsException e) {
                throw new SNoSuchElementException("current=" + this.current);
            }
        }

        @Override
        public void remove() {
            AssertionUtil.assertState(this.last != -1, "last == -1");
            ArrayMap.this.remove(this.last);
            if (this.last < this.current) {
                --this.current;
            }
            this.last = -1;
        }
    }
}

