/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.transaction;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.seasar.util.exception.SystemRuntimeException;
import org.seasar.util.misc.AssertionUtil;

public abstract class TransactionManagerUtil {
    public static Transaction getTransaction(TransactionManager tm) throws SystemRuntimeException {
        AssertionUtil.assertArgumentNotNull("tm", tm);
        try {
            return tm.getTransaction();
        }
        catch (SystemException e) {
            throw new SystemRuntimeException(e);
        }
    }

    public static boolean isActive(TransactionManager tm) {
        AssertionUtil.assertArgumentNotNull("tm", tm);
        return TransactionManagerUtil.getStatus(tm) != 6;
    }

    public static int getStatus(TransactionManager tm) throws SystemRuntimeException {
        AssertionUtil.assertArgumentNotNull("tm", tm);
        try {
            return tm.getStatus();
        }
        catch (SystemException e) {
            throw new SystemRuntimeException(e);
        }
    }

    public static void setRollbackOnly(TransactionManager tm) throws SystemRuntimeException {
        AssertionUtil.assertArgumentNotNull("tm", tm);
        try {
            tm.setRollbackOnly();
        }
        catch (SystemException e) {
            throw new SystemRuntimeException(e);
        }
    }
}

