package com.tryandroid.sensor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.tryandroid.R;

import android.app.Activity;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.util.Log;
import android.widget.ListView;
import android.widget.SimpleAdapter;

public class SensorListActivity extends Activity {
	private static final String ITEM = "Item";
	private static final String VALUE = "Value";

	private SensorManager sensorManager;

	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.sensor_list);

		// SensorManager取得
		sensorManager = (SensorManager) this.getSystemService(SENSOR_SERVICE);

		// Sensor一覧取得
		List<Sensor> sensors = sensorManager.getSensorList(Sensor.TYPE_ALL);
		Log.i(getClass().getName(), "Size=" + sensors.size());

		// Adapter作成
		List<Map<String, String>> data = new ArrayList<Map<String, String>>();
		for (Sensor e : sensors) {
			Map<String, String> m = new HashMap<String, String>();
			m.put(ITEM, e.getName());
			m.put(VALUE, getSensorValue(e));
			data.add(m);
		}

		// ListViewへSensor追加
		ListView listView = (ListView) findViewById(R.id.sensor_list_list_view);
		listView.setAdapter(new SimpleAdapter(SensorListActivity.this, data,
				android.R.layout.simple_list_item_2,
				new String[] { ITEM, VALUE }, new int[] { android.R.id.text1,
						android.R.id.text2 }));
	}

	private String getSensorValue(Sensor s) {
		return "Type=" + getSensorTypeString(s.getType()) + ", 精度="
				+ String.valueOf(s.getResolution()) + ", 検出可能最大値="
				+ String.valueOf(s.getMaximumRange()) + ", パワー="
				+ String.valueOf(s.getPower()) + "mA" + ", ベンダ="
				+ s.getVendor() + ", バージョン=" + s.getVersion();
	}

	private String getSensorTypeString(int type) {
		switch (type) {
		case Sensor.TYPE_ACCELEROMETER:
			return "加速度";
		case Sensor.TYPE_GYROSCOPE:
			return "ジャイロスコープ";
		case Sensor.TYPE_LIGHT:
			return "輝度";
		case Sensor.TYPE_MAGNETIC_FIELD:
			return "磁界";
		case Sensor.TYPE_ORIENTATION:
			return "傾き";
		case Sensor.TYPE_PRESSURE:
			return "プレッシャー";
		case Sensor.TYPE_PROXIMITY:
			return "近接";
		case Sensor.TYPE_TEMPERATURE:
			return "温度";
		}
		return "Unknown";
	}

}