/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.api;

import org.json.JSONArray;
import org.json.JSONObject;

public class PluginResult {
    private final int status;
    private final String message;
    private boolean keepCallback = false;
    public static String[] StatusMessages = new String[]{"No result", "OK", "Class not found", "Illegal access", "Instantiation error", "Malformed url", "IO error", "Invalid action", "JSON error", "Error"};

    public PluginResult(Status status) {
        this.status = status.ordinal();
        this.message = "'" + StatusMessages[this.status] + "'";
    }

    public PluginResult(Status status, String message) {
        this.status = status.ordinal();
        this.message = JSONObject.quote((String)message);
    }

    public PluginResult(Status status, JSONArray message) {
        this.status = status.ordinal();
        this.message = message.toString();
    }

    public PluginResult(Status status, JSONObject message) {
        this.status = status.ordinal();
        this.message = message.toString();
    }

    public PluginResult(Status status, int i) {
        this.status = status.ordinal();
        this.message = "" + i;
    }

    public PluginResult(Status status, float f) {
        this.status = status.ordinal();
        this.message = "" + f;
    }

    public PluginResult(Status status, boolean b) {
        this.status = status.ordinal();
        this.message = "" + b;
    }

    public void setKeepCallback(boolean b) {
        this.keepCallback = b;
    }

    public int getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean getKeepCallback() {
        return this.keepCallback;
    }

    public String getJSONString() {
        return "{status:" + this.status + ",message:" + this.message + ",keepCallback:" + this.keepCallback + "}";
    }

    public String toSuccessCallbackString(String callbackId) {
        return "require('cordova').callbackSuccess('" + callbackId + "'," + this.getJSONString() + ");";
    }

    public String toErrorCallbackString(String callbackId) {
        return "require('cordova').callbackError('" + callbackId + "', " + this.getJSONString() + ");";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        NO_RESULT,
        OK,
        CLASS_NOT_FOUND_EXCEPTION,
        ILLEGAL_ACCESS_EXCEPTION,
        INSTANTIATION_EXCEPTION,
        MALFORMED_URL_EXCEPTION,
        IO_EXCEPTION,
        INVALID_ACTION,
        JSON_EXCEPTION,
        ERROR;

    }
}

