/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.aptina.commons.util;

import java.util.List;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.seasar.aptina.commons.util.AssertionUtils;
import org.seasar.aptina.commons.util.CollectionUtils;

public class DiagnosticUtils {
    private DiagnosticUtils() {
    }

    public static List<Diagnostic<? extends JavaFileObject>> getDiagnostics(List<Diagnostic<? extends JavaFileObject>> diagnostics, Class<?> clazz) {
        AssertionUtils.assertNotNull("clazz", clazz);
        return DiagnosticUtils.getDiagnostics(diagnostics, clazz.getName());
    }

    public static List<Diagnostic<? extends JavaFileObject>> getDiagnostics(List<Diagnostic<? extends JavaFileObject>> diagnostics, String className) {
        AssertionUtils.assertNotNull("className", className);
        String name = className.replace('.', '/') + ".java";
        List<Diagnostic<? extends JavaFileObject>> result = CollectionUtils.newArrayList();
        for (Diagnostic<? extends JavaFileObject> diagnositc : diagnostics) {
            JavaFileObject source = diagnositc.getSource();
            if (source == null || !source.toUri().toString().endsWith(name)) continue;
            result.add(diagnositc);
        }
        return result;
    }

    public static List<Diagnostic<? extends JavaFileObject>> getDiagnostics(List<Diagnostic<? extends JavaFileObject>> diagnostics, Diagnostic.Kind kind) {
        AssertionUtils.assertNotNull("kind", (Object)kind);
        List<Diagnostic<? extends JavaFileObject>> result = CollectionUtils.newArrayList();
        for (Diagnostic<? extends JavaFileObject> diagnositc : diagnostics) {
            if (!diagnositc.getKind().equals((Object)kind)) continue;
            result.add(diagnositc);
        }
        return result;
    }

    public static List<Diagnostic<? extends JavaFileObject>> getDiagnostics(List<Diagnostic<? extends JavaFileObject>> diagnostics, Class<?> clazz, Diagnostic.Kind kind) {
        AssertionUtils.assertNotNull("clazz", clazz);
        AssertionUtils.assertNotNull("kind", (Object)kind);
        return DiagnosticUtils.getDiagnostics(diagnostics, clazz.getName(), kind);
    }

    public static List<Diagnostic<? extends JavaFileObject>> getDiagnostics(List<Diagnostic<? extends JavaFileObject>> diagnostics, String className, Diagnostic.Kind kind) {
        AssertionUtils.assertNotNull("className", className);
        AssertionUtils.assertNotNull("kind", (Object)kind);
        String name = className.replace('.', '/') + ".java";
        List<Diagnostic<? extends JavaFileObject>> result = CollectionUtils.newArrayList();
        for (Diagnostic<? extends JavaFileObject> diagnositc : diagnostics) {
            JavaFileObject source = diagnositc.getSource();
            if (source == null || !source.toUri().toString().endsWith(name) || !diagnositc.getKind().equals((Object)kind)) continue;
            result.add(diagnositc);
        }
        return result;
    }
}

