#!/bin/sh
#
# Make a KOZOS development environment on Ubuntu 12.04
# Copyright(C) 2012 Shinichiro Nakamura
#
BINUTILS=binutils-2.19.1
GCC=gcc-3.4.6
CURDIR=`pwd`

#
# sudo check
#
sudo ls

#
# binutils
#
if [ ! -e $BINUTILS.tar.gz ]
then
    wget http://ftp.gnu.org/gnu/binutils/$BINUTILS.tar.bz2
    tar xvfj $BINUTILS.tar.bz2
fi
cd $BINUTILS
./configure --target=h8300-elf --disable-nls
make
sudo make install
cd $CURDIR

#
# gcc
#
if [ ! -e $GCC.tar.gz ]
then
    wget ftp://ftp.dti.ad.jp/pub/lang/gcc/releases/$GCC/$GCC.tar.gz
    tar xvfz $GCC.tar.gz
fi
cd $GCC
./configure --target=h8300-elf --disable-nls --disable-threads --disable-shared --enable-languages=c
TMPFILE=`mktemp`
sed -e "1537s/O_CREAT)/O_CREAT, 0755)/g" gcc/collect2.c > $TMPFILE
mv $TMPFILE gcc/collect2.c
make
sudo make install
cd $CURDIR

#
# sample codes
#
wget http://www.saturn.dti.ne.jp/~hsakai/kozos/osbook/osbook_03.zip
unzip -q osbook_03.zip

