#include "defines.h"
#include "kozos.h"
#include "driver_timer.h"
#include "driver_led.h"
#include "driver_lcd.h"
#include "lib.h"
#include "sw.h"
#include "re.h"

int task_userinput(int argc, char *argv[])
{
  int nx = 40, ny = 12;
  re_init();
  sw_init();

  lcddrv_clear();
  lcddrv_draw_logo(  0, 0, 2);
  lcddrv_draw_box(0, 0, 121, 31, 1);
  lcddrv_draw_text(40, 4, "KOZOS EXPBRD #00");

  lcddrv_draw_logo(nx, ny, 0);

  uint16 prev = 0, curr = 0;
  while (1) {
    curr = re_read();
    if (curr != prev) {
      int dir = (int)(curr & 0xff) - (int)(prev & 0xff);
      if (dir < 0) {
        if (-32 < dir) {
          leddrv_write(1, 0);
          leddrv_toggle(0);
        }
        if (40 < nx) {
          nx--;
        }
      } else {
        if (dir < 32) {
          leddrv_write(0, 0);
          leddrv_toggle(1);
        }
        if (nx < 100) {
          nx++;
        }
      }
      prev = curr;

      lcddrv_draw_box(nx + 20, ny, nx + 20, ny + 16, 0);
      lcddrv_draw_logo(nx, ny, 0);
    }

    timerdrv_start(5);
    timerdrv_wait();
    leddrv_toggle(3);
  }

  return 0;
}
