#include "defines.h"
#include "kozos.h"
#include "driver_console.h"
#include "driver_led.h"
#include "lib.h"

int task_command(int argc, char *argv[])
{
  char *p;
  int size;

  console_use(SERIAL_DEFAULT_DEVICE);

  while (1) {
    console_write("command> "); /* ץץɽ */

    /* 󥽡뤫μʸ */
    kz_recv(MSGBOX_ID_CONSINPUT, &size, &p);
    if (p == NULL) {
      console_write("expired.\n");
      continue;
    }
    p[size] = '\0';

    if (!strncmp(p, "echo", 4)) { /* echoޥ */
      console_write(p + 4); /* echo³ʸϤ */
      console_write("\n");
    } else if (!strncmp(p, "led1", 4)) {
      leddrv_toggle(0);
    } else if (!strncmp(p, "led2", 4)) {
      leddrv_toggle(1);
    } else if (!strncmp(p, "ledg", 4)) {
      leddrv_toggle(2);
    } else if (!strncmp(p, "ledr", 4)) {
      leddrv_toggle(3);
    } else {
      console_write("unknown.\n");
    }

    kz_kmfree(p);
  }

  return 0;
}
