C     THIS IS THE FIRST FILE OF ASTO-RELEATED ROUTINES
C
      SUBROUTINE P33_1(b,a,e)
C     EQUATION 1, PAGE 33, ORBITS FOR AMATEURS WITH A MICROCOMPUTER
C     THIS ROUTINE COMPUTES THE SEMI-MINOR AXIS OF AN ELLIPSE FROM SEMI-MAJOR
C     AXIS AND THE ECCENTRICITY
      REAL*8 A,B,E
      B=DSQRT((A**2)*(1.0D0-(E**2)))
      RETURN
      END
C
C
      SUBROUTINE P33_2_1(R,W,O)
C     EQUATION 2-1, PAGE 33, ORBITS FOR AMATEURS WITH A MICROCOMPUTER
C     THIS ROUTINE COMPUTES SUBSIDIARY QUANTITIES
C     W=ARGUMENT OF PERIHELION,O=LONGITUDE OF ASCENDING NODE,R=RESULT
C     W AND O ASSUME ANGLES IN RADIANS
      REAL*8 R,W,O
      R=DSIN(W)*DSIN(O)
      RETURN
      END
C
C
      SUBROUTINE P33_2_2(R,W,O)
C     EQUATION 2-2, PAGE 33, ORBITS FOR AMATEURS WITH A MICROCOMPUTER
C     THIS ROUTINE COMPUTES SUBSIDIARY QUANTITIES
C     W=ARGUMENT OF PERIHELION,O=LONGITUDE OF ASCENDING NODE,R=RESULT
C     W AND O ASSUME ANGLES IN RADIANS
      REAL*8 R,W,O
      R=DSIN(W)*DCOS(O)
      RETURN
      END
C
C
      SUBROUTINE P33_2_3(R,W,I)
C     EQUATION 2-3, PAGE 33, ORBITS FOR AMATEURS WITH A MICROCOMPUTER
C     THIS ROUTINE COMPUTES SUBSIDIARY QUANTITIES
C     W=ARGUMENT OF PERIHELION,I=ANGLE OF INCLINATION
C     W AND I ASSUME ANGLES IN RADIANS
      REAL*8 R,W,I
      R=DSIN(W)*DSIN(I)
      RETURN
      END
C
C
      SUBROUTINE P33_2_4(R,W,O)
C     EQUATION 2-4, PAGE 33, ORBITS FOR AMATEURS WITH A MICROCOMPUTER
C     THIS ROUTINE COMPUTES SUBSIDIARY QUANTITIES
C     W=ARGUMENT OF PERIHELION,O=LONGITUDE OF ASCENDING NODE,R=RESULT
C     W AND O ASSUME ANGLES IN RADIANS
      REAL*8 R,W,O
      R=DCOS(W)*DSIN(O)
      RETURN
      END
C
C
C
      SUBROUTINE P33_2_5(R,W,O)
C     EQUATION 2-5, PAGE 33, ORBITS FOR AMATEURS WITH A MICROCOMPUTER
C     THIS ROUTINE COMPUTES SUBSIDIARY QUANTITIES
C     W=ARGUMENT OF PERIHELION,O=LONGITUDE OF ASCENDING NODE,R=RESULT
C     W AND O ASSUME ANGLES IN RADIANS
      REAL*8 R,W,O
      R=DCOS(W)*DCOS(O)
      RETURN
      END
C
C
      SUBROUTINE P33_2_6(R,W,I)
C     EQUATION 2-6, PAGE 33, ORBITS FOR AMATEURS WITH A MICROCOMPUTER
C     THIS ROUTINE COMPUTES SUBSIDIARY QUANTITIES
C     W=ARGUMENT OF PERIHELION,I=ANGLE OF INCLINATION
C     W AND I ASSUME ANGLES IN RADIANS
      REAL*8 R,W,I
      R=DCOS(W)*DSIN(I)
      RETURN
      END
C
C
      SUBROUTINE P33_2_7(R,W,O,I)
C     EQUATION 2-7, PAGE 33, ORBITS FOR AMATEURS WITH A MICROCOMPUTER
C     THIS ROUTINE COMPUTES SUBSIDIARY QUANTITIES
C     W=ARGUMENT OF PERIHELION,I=ANGLE OF INCLINATION,O=LONGITUDE OF ASCENDING NODE
C     W,O AND I ASSUME ANGLES IN RADIANS
      REAL*8 R,W,I,O
      R=((DCOS(W)*DCOS(O))*DCOS(I))-(DSIN(W)*DSIN(O))
      RETURN
      END
C
C
      SUBROUTINE P33_2_8(R,W,O,I)
C     EQUATION 2-8, PAGE 33, ORBITS FOR AMATEURS WITH A MICROCOMPUTER
C     THIS ROUTINE COMPUTES SUBSIDIARY QUANTITIES
C     W=ARGUMENT OF PERIHELION,I=ANGLE OF INCLINATION,O=LONGITUDE OF ASCENDING NODE
C     W,O AND I ASSUME ANGLES IN RADIANS
      REAL*8 R,W,I,O
      R=((DSIN(W)*DCOS(O))*DCOS(I))+(DCOS(W)*DSIN(O))
      RETURN
      END
C
C
      SUBROUTINE P33_PX(R,W,O,I)
C     EQUATION 3-PX,PAGE 33, ORBITS FOR AMATEURS WITH A MICROCOMPUTER
C     THIS ROUTINE COMPUTES PX AS R
C     W=ARGUMENT OF PERIHELION,I=ANGLE OF INCLINATION,O=LONGITUDE OF ASCENDING NODE
C     W,O AND I ASSUME ANGLES IN RADIANS
      REAL*8 R,W,I,O
      R=(DCOS(W)*DCOS(O))-((DSIN(W)*DSIN(O))*DCOS(I))
      RETURN
      END
C
C
      SUBROUTINE P33_PY(R,W,O,I,E)
C     EQUATION 3-PY,PAGE 33, ORBITS FOR AMATEURS WITH A MICROCOMPUTER
C     THIS ROUTINE COMPUTES PY AS R
C     W=ARGUMENT OF PERIHELION,I=ANGLE OF INCLINATION,O=LONGITUDE OF ASCENDING NODE
C     E=ANGLE OF THE OBLIQUITY OF THE ECLIPTIC
C     W,O AND I ASSUME ANGLES IN RADIANS
      REAL*8 R,W,I,O,T8,T3,E
      T8=((DSIN(W)*DCOS(O))*DCOS(I))+(DCOS(W)*DSIN(O))
      T3=DSIN(W)*DSIN(I)
      R=(T8*DCOS(E))-(T3*DSIN(E))
      RETURN
      END
C
C
      SUBROUTINE P33_PZ(R,W,O,I,E)
C     EQUATION 3-PZ,PAGE 33, ORBITS FOR AMATEURS WITH A MICROCOMPUTER
C     THIS ROUTINE COMPUTES PZ AS R
C     W=ARGUMENT OF PERIHELION,I=ANGLE OF INCLINATION,O=LONGITUDE OF ASCENDING NODE
C     E=ANGLE OF THE OBLIQUITY OF THE ECLIPTIC
C     W,O AND I ASSUME ANGLES IN RADIANS
      REAL*8 R,W,I,O,T8,T3,E
      T8=((DSIN(W)*DCOS(O))*DCOS(I))+(DCOS(W)*DSIN(O))
      T3=DSIN(W)*DSIN(I)
      R=(T3*DCOS(E))+(T8*DSIN(E))
      RETURN
      END
C
C
      SUBROUTINE P33_QX(R,W,O,I)
C     EQUATION 3-QX,PAGE 33, ORBITS FOR AMATEURS WITH A MICROCOMPUTER
C     THIS ROUTINE COMPUTES QX AS R
C     W=ARGUMENT OF PERIHELION,I=ANGLE OF INCLINATION,O=LONGITUDE OF ASCENDING NODE
C     E=ANGLE OF THE OBLIQUITY OF THE ECLIPTIC
C     W,O AND I ASSUME ANGLES IN RADIANS
      REAL*8 R,W,I,O,T2,T4
      T2=DSIN(W)*DCOS(O)
      T4=DCOS(W)*DSIN(O)
      R=-T2-(T4*DCOS(I))
      RETURN
      END
C
C
      SUBROUTINE P33_QY(R,W,O,I,E)
C     EQUATION 3-QY,PAGE 33, ORBITS FOR AMATEURS WITH A MICROCOMPUTER
C     THIS ROUTINE COMPUTES QY AS R
C     W=ARGUMENT OF PERIHELION,I=ANGLE OF INCLINATION,O=LONGITUDE OF ASCENDING NODE
C     E=ANGLE OF THE OBLIQUITY OF THE ECLIPTIC
C     W,O AND I ASSUME ANGLES IN RADIANS
      REAL*8 R,W,I,O,T6,T7,E
      T6=DCOS(W)*DSIN(I)
      T7=((DCOS(W)*DCOS(O))*DCOS(I))-(DSIN(W)*DSIN(O))
      R=(T7*DCOS(E))-(T6*DSIN(E))
      RETURN
      END
C
C
      SUBROUTINE P33_QZ(R,W,O,I,E)
C     EQUATION 3-QZ,PAGE 33, ORBITS FOR AMATEURS WITH A MICROCOMPUTER
C     THIS ROUTINE COMPUTES QZ AS R
C     W=ARGUMENT OF PERIHELION,I=ANGLE OF INCLINATION,O=LONGITUDE OF ASCENDING NODE
C     E=ANGLE OF THE OBLIQUITY OF THE ECLIPTIC
C     W,O AND I ASSUME ANGLES IN RADIANS
      REAL*8 R,W,I,O,T6,T7,E
      T6=DCOS(W)*DSIN(I)
      T7=((DCOS(W)*DCOS(O))*DCOS(I))-(DSIN(W)*DSIN(O))
      R=(T6*DCOS(E))+(T7*DSIN(E))
      RETURN
      END
C
C
      SUBROUTINE P33_AX(R,A,PX)
C     EQUATION 4-AX,PAGE 33, ORBITS FOR AMATEURS WITH A MICROCOMPUTER
C     THIS ROUTINE COMPUTES AX AS R
C     A=SEMI-MAJOR AXIS, AND PX
      REAL*8 A,PX,R
      R=A*PX
      RETURN
      END
C
C
      SUBROUTINE P33_AY(R,A,PY)
C     EQUATION 4-AY,PAGE 33, ORBITS FOR AMATEURS WITH A MICROCOMPUTER
C     THIS ROUTINE COMPUTES AY AS R
C     A=SEMI-MAJOR AXIS, AND PY
      REAL*8 A,PY,R
      R=A*PY
      RETURN
      END
C
C
      SUBROUTINE P33_AZ(R,A,PZ)
C     EQUATION 4-AZ,PAGE 33, ORBITS FOR AMATEURS WITH A MICROCOMPUTER
C     THIS ROUTINE COMPUTES AZ AS R
C     A=SEMI-MAJOR AXIS, AND PZ
      REAL*8 A,PZ,R
      R=A*PZ
      RETURN
      END
C
C
      SUBROUTINE P33_BX(R,A,QX)
C     EQUATION 4-BX,PAGE 33, ORBITS FOR AMATEURS WITH A MICROCOMPUTER
C     THIS ROUTINE COMPUTES BX AS R
C     A=SEMI-MAJOR AXIS AND QX
      REAL*8 A,QX,R
      R=A*QX
      RETURN
      END
C
C
      SUBROUTINE P33_BY(R,A,QY)
C     EQUATION 4-BY,PAGE 33, ORBITS FOR AMATEURS WITH A MICROCOMPUTER
C     THIS ROUTINE COMPUTES BY AS R
C     A=SEMI-MAJOR AXIS AND QY
      REAL*8 A,QY,R
      R=A*QY
      RETURN
      END
C
C
      SUBROUTINE P33_BZ(R,A,QZ)
C     EQUATION 4-BZ,PAGE 33, ORBITS FOR AMATEURS WITH A MICROCOMPUTER
C     THIS ROUTINE COMPUTES BZ AS R
C     A=SEMI-MAJOR AXIS AND QZ
      REAL*8 A,QZ,R
      R=A*QZ
      RETURN
      END
C
C
      SUBROUTINE P33_M(R,N,SMALLT,BIGT)
C     EQUATION 6,PAGE 33, ORBITS FOR AMATEURS WITH A MICROCOMPUTER
C     THIS ROUTINE COMPUTES M, THE MEAN ANOMOLY AS R
C     BIGT IS THE TIME OF PEIHELION PASSAGE, N=MEAN MOTION,SMALLT = TIME
      REAL*8 N,SMALLT,BIGT,R
      R=N*(SMALLT-BIGT)
      RETURN
      END
C
C
      SUBROUTINE P33_R(R,A,E,LARGEE)
C     EQUATION 7,PAGE 33, ORBITS FOR AMATEURS WITH A MICROCOMPUTER
C     THIS ROUTINE COMPUTES r-DISTANCE TO THE SUN AS R
C     A=SEMI-MAJOR AXIS, E=ECCENTRICITY,LARGEE=ECCENTRIC ANOMOLY
      REAL*8 R,A,E,LARGEE
      R=A*(1.0D0-(E*DCOS(LARGEE)))
      RETURN
      END
C
C
      SUBROUTINE P33_X(R,AX,E,LARGEE,BX)
C     EQUATION 8,PAGE 33, ORBITS FOR AMATEURS WITH A MICROCOMPUTER
C     THIS ROUTINE COMPUTES X-HELIOCENTRIC COORDINATE AS R
C     E=ECCENTRICITY,LARGEE=ECCENTRIC ANOMOLY
C     AX AND BX FROM ABOVE ROUTINES
      REAL*8 R,E,LARGEE,AX,BX
      R=(AX*(DCOS(LARGEE)-E))+(BX*DSIN(LARGEE))
      RETURN
      END
C
      SUBROUTINE P33_Y(R,AY,E,LARGEE,BY)
C     EQUATION 8,PAGE 33, ORBITS FOR AMATEURS WITH A MICROCOMPUTER
C     THIS ROUTINE COMPUTES Y-HELIOCENTRIC COORDINATE AS R
C     E=ECCENTRICITY,LARGEE=ECCENTRIC ANOMOLY
C     AY AND BY FROM ABOVE ROUTINES
      REAL*8 R,E,LARGEE,AY,BY
      R=(AY*(DCOS(LARGEE)-E))+(BY*DSIN(LARGEE))
      RETURN
      END
C
      SUBROUTINE P33_Z(R,AZ,E,LARGEE,BZ)
C     EQUATION 8,PAGE 33, ORBITS FOR AMATEURS WITH A MICROCOMPUTER
C     THIS ROUTINE COMPUTES Z-HELIOCENTRIC COORDINATE AS R
C     E=ECCENTRICITY,LARGEE=ECCENTRIC ANOMOLY
C     AZ AND BZ FROM ABOVE ROUTINES
      REAL*8 R,E,LARGEE,AZ,BZ
      R=(AZ*(DCOS(LARGEE)-E))+(BZ*DSIN(LARGEE))
      RETURN
      END
C
C
      SUBROUTINE P33_R2(R,X,Y,Z)
C     EQUATION 9,PAGE 33, ORBITS FOR AMATEURS WITH A MICROCOMPUTER
C     THIS ROUTINE COMPUTES R SQUARED AS A CHECK
      REAL*8 R,X,Y,Z
      R=(X**2)+(Y**2)+(Z**2)
      RETURN
      END
C
C
C
