#include "mainwindowimpl.h"
//
MainWindowImpl::MainWindowImpl( QWidget * parent, Qt::WFlags f) 
	: QMainWindow(parent, f)
{
	setupUi(this);

	// Network setup
	uPnPSocket = new	QUdpSocket(this);
	uPnPSocket->bind();
	connection = new QHttp(this);
	if(connection == NULL)
	{
		QMessageBox::critical(this, tr("Initialize error"), tr("Error occored for application initialize."));
		close();
	}
	
	// Create and setting timers
	timeoutTimer = new QTimer();
	timeoutTimer->setSingleShot(true);
	timeoutTimer->setInterval(discoverTimeout);
	
	progressTimer = new QTimer();
	progressTimer->setSingleShot(false);
	progressTimer->setInterval(progressInterval);
	
	// SOAP request message setup
	QFile	request(":/Text/CCBrowse.xml");
	request.open(QIODevice::ReadOnly);
	browseRequest = request.readAll();
	
	// Create dialogs
	progressDialog = new ProgressDialog(this);

	// Slot connection
	connect(timeoutTimer, SIGNAL(timeout()), this, SLOT(selectServers()));
	connect(uPnPSocket, SIGNAL(readyRead()), this, SLOT(serverDiscovered()));
	connect(connection, SIGNAL(requestFinished(int, bool)), this, SLOT(httpRequestFinished(int, bool)));
	connect(progressTimer, SIGNAL(timeout()), this, SLOT(progressUpdate()));
	connect(progressDialog->findChild<QDialogButtonBox*>("buttonBox"), SIGNAL(rejected()),
			this, SLOT(downloadCanceled()));
	serverList = new QList<serverInfo*>();
	videoList = new QList<videoInfo*>();
	downloadQueue = new QList<videoInfo*>();
	
	discoverChannelServer();
}

/*
	Update video list
*/

void	MainWindowImpl::updateList()
{
	videoList->clear();
	buf = new QBuffer;
	buf->open(QIODevice::ReadWrite);
	connection->setHost(serverAddress, serverPort);
	QString request(browseRequest);
	QHttpRequestHeader	header("POST", "/upnp/control/ContentDirectory");
	header.setValue("Host", serverAddress + ":" + serverPort);
	header.addValue("SOAPAction", "\"urn:schemas-upnp-org:service:ContentDirectory:1#Browse\"");
	browseId = connection->request(header, request.arg(0).arg(40).toUtf8(), buf);
	statusBar()->showMessage(tr("Downloading video list..."));
}

/*
	Show (selected) video file detail dialog
*/

void	MainWindowImpl::showVideoDetail()
{
	QModelIndexList	selections = videoListView->selectionModel()->selectedRows();
	QModelIndex	selection;
	QModelIndexList::iterator	iter = selections.begin();
	while(iter != selections.end())
	{
		QList<videoInfo*>::iterator	infoIter = videoList->begin();
		while((*infoIter)->id != (*iter).data().toString())
		{
			infoIter++;
		}
		if(infoIter != videoList->end())
		{
			videoDetailImpl	*detailDialog = new videoDetailImpl();

			detailDialog->findChild<QLineEdit*>("title")->setText((*infoIter)->title);
			detailDialog->findChild<QLineEdit*>("url")->setText((*infoIter)->url);
			detailDialog->findChild<QLabel*>("size")->setText(QString("%L1 bytes").arg((*infoIter)->size.toULongLong()));
			detailDialog->findChild<QLabel*>("channel")->setText((*infoIter)->channel);
			detailDialog->findChild<QLabel*>("date")->setText((*infoIter)->datetime);
			detailDialog->findChild<QLabel*>("duration")->setText((*infoIter)->duration);
			detailDialog->findChild<QLabel*>("bitrate")->setText(QString("%1 bps").arg((*infoIter)->bitrate));

			detailDialog->show();
			detailDialog->activateWindow();
			detailDialog->raise();
		}
		iter++;
	}
}

/*
	Discover channel server by SSDP Discover
*/

void	MainWindowImpl::discoverChannelServer()
{
	serverList->clear();
	QHostAddress	address(uPnPAddress);
	uPnPSocket->writeDatagram(uPnPRequest.toUtf8() + uPnPRequest.toUtf8(), uPnPRequest.length() * 2, address, uPnPPort);
	timeoutTimer->start();
	statusBar()->showMessage(tr("Discovering servers..."));
	
}

void	MainWindowImpl::serverDiscovered()
{
	// Receive response from server
	
	QByteArray	response;
	response.resize(uPnPSocket->pendingDatagramSize());
	uPnPSocket->readDatagram(response.data(), response.size());
	QString resMessage = response.data();
	// server kind and address
	resMessage.replace("\r", "");
	resMessage.chop(2);
	QStringList	list = resMessage.split("\n");
	QList<QString>::iterator	iter = list.begin();
	QMap<QString, QString>	itemMap;
	iter++;
	while(iter != list.end())
	{
		QString	line = *iter;
		if(line.contains(": "))
		{
			QString	key = line.mid(0, line.indexOf(": "));
			QString	value = line.mid(line.indexOf(": ") + 2);
			itemMap.insert(key, value);
		}
		iter++;
	}
	QString info = itemMap.value("X-AV-Physical-Unit-Info");
	int	s = info.indexOf("pa = \"") + 6;
	QString unitName = info.mid(s, info.indexOf("\"", s) - s);
	QString	desc = itemMap.value("LOCATION");
	serverInfo	*server = new serverInfo;
	server->descUrl = desc;
	server->info = unitName;
	serverList->append(server);
	QUrl	descUrl(desc);
}

/*
	Open server selection dialog
*/

void	MainWindowImpl::selectServers()
{
	statusBar()->showMessage(tr("Server discovered"), 5000);
	if(serverList->empty())
	{
		QMessageBox::critical(this, tr("No server found"), tr("No server found.Quit application."));
		this->close();
	}
	
	serverDialogImpl	dialog(serverList, this);
	if(dialog.exec() == QDialog::Accepted)
	{
		QModelIndex	selected(dialog.findChild<QTableView*>()->currentIndex());
		if(selected.isValid())
		{
			serverSelected(dialog.findChild<QTableView*>("serverListView")->currentIndex());
		}
	}
	dialog.close();
}

void	MainWindowImpl::serverSelected(const QModelIndex	index)
{
	serverInfo	*info = serverList->at(index.row());
	QUrl	serverUrl(info->descUrl);

	serverAddress = serverUrl.host();
	serverPort = serverUrl.port(50001);
	
	buf = new QBuffer;
	connection->setHost(serverUrl.host(), serverUrl.port());
	descId = connection->get(serverUrl.path(), buf);
}

void	MainWindowImpl::httpRequestFinished(int	id, bool	error)
{
	// Error handling
	if(error)
	{
		QMessageBox::warning(this, tr("Network Error"), tr("Can't connect to channel server"));
		qDebug() << "HTTP network error";
		return;
	}
	// Received server description file
	if(id == descId)
	{
		QString	desc = buf->data();
		updateList();
	}
	// Received video list
	if(id == browseId)
	{
		QTextCodec	*codec = QTextCodec::codecForName("UTF-8");
		QString list = codec->toUnicode(buf->data());
		delete buf;
		list.replace("&lt;", "<");
		list.replace("&gt;", ">");
		list.replace("&quot;", "\"");
		list.replace("&amp;", "&");
		list.replace("&apos;", "'");
		
		int	starttag = list.indexOf("<TotalMatches>", 0, Qt::CaseInsensitive) + 14;
		int	totalCount = list.mid(starttag, list.indexOf("</TotalMatches>", starttag, Qt::CaseInsensitive) - starttag).toInt();
		
		statusBar()->showMessage(tr("%1 / %2 Downloaded").arg(videoList->count()).arg(totalCount));
		
		// Open envelope
		list.remove(0, list.indexOf("<Result>", 0,  Qt::CaseInsensitive) + 8);
		list.chop(list.length() - list.lastIndexOf("</Result>", -1, Qt::CaseInsensitive));
		
		// Video list view update
		QXmlInputSource	resultXml;
		resultXml.setData(list);
		BrowseHandler	handler(videoList);
		QXmlSimpleReader	reader;
		reader.setContentHandler(&handler);
		reader.setErrorHandler(&handler);
		bool status = reader.parse(&resultXml);
		if(status == false)
		{
			qDebug() << "Parse error";
		}
		if(videoList->count() < totalCount - 1)
		{
			QString	request = browseRequest;
			buf = new QBuffer;
			buf->open(QIODevice::ReadWrite);
			connection->setHost(serverAddress, serverPort);
			QHttpRequestHeader	header("POST", "/upnp/control/ContentDirectory");
			header.setValue("Host", serverAddress + ":" + serverPort);
			header.addValue("SOAPAction", "\"urn:schemas-upnp-org:service:ContentDirectory:1#Browse\"");
			browseId = connection->request(header, request.arg(videoList->count() + 1).arg(40).toUtf8(), buf);
		}
		else
		{
			statusBar()->showMessage(tr("Making video list..."));
			videoTableModel = new QStandardItemModel();
			int	row = 0;
			QList<videoInfo*>::iterator	iter = videoList->begin();
			while(iter != videoList->end())
			{
				videoInfo	*item = *iter;
				videoTableModel->setItem(row, 0, new QStandardItem(item->id));
				videoTableModel->setItem(row, 1, new QStandardItem(item->title));
				videoTableModel->setItem(row, 2, new QStandardItem(item->datetime));
				videoTableModel->setItem(row, 3, new QStandardItem(item->duration));
				videoTableModel->setItem(row, 4, new QStandardItem(item->channel));
				iter++, row++;
			}
			QStringList	headerList;
			headerList.append(tr("ID"));
			headerList.append(tr("Title"));
			headerList.append(tr("Date"));
			headerList.append(tr("Duration"));
			headerList.append(tr("Ch"));
			
			videoTableModel->setHorizontalHeaderLabels(headerList);
			videoListView->setModel(videoTableModel);
			videoListView->resizeColumnsToContents();
			statusBar()->showMessage(tr("Download complete"), 5000);
		}
	}
	// Video file downloaded
	if(id == downloadId)
	{
		if(videoFile->exists())
		{
			videoFile->close();
		}
		progressTimer->stop();
		downloadQueue->removeFirst();
		downloadRequest();
	}
}

/*
	Download video file(s)
*/

void	MainWindowImpl::downloadVideo()
{
//	QList<videoInfo*>	downloadQueue = new QList<videoList*>();
	
	QModelIndexList	selectedVideo = videoListView->selectionModel()->selectedRows();
	QModelIndexList::iterator	iter = selectedVideo.begin();
	
	// Select save directory of video file(s)
	downloadDir = QFileDialog::getExistingDirectory(this, tr("Choose save directory"), "~");
	if(downloadDir.isEmpty())
	{
		return;
	}
	while(iter != selectedVideo.end())
	{
		
		// Find selected video info
		QString	targetId = (*iter).data().toString();
		qDebug() << targetId;
		QList<videoInfo*>::iterator	listiter;
		for(listiter = videoList->begin(); (*listiter)->id != targetId; listiter++)
		{
			if(listiter == videoList->end())
				return;
		}
		downloadQueue->append(*listiter);
		iter++;
	}
	downloadRequest();
}

void	MainWindowImpl::downloadRequest()
{
	qDebug() << "downloadRequest() called";
	if(downloadQueue->isEmpty())
	{
		progressDialog->hide();
		return;
	}
	videoInfo	*targetVideo = downloadQueue->first();
	
	// Make video infomation file
	QFile	infoFile(downloadDir + targetVideo->id + videoInfoExt);
	if(infoFile.exists())
	{
		QMessageBox::warning(this, tr("File error"), tr("File already exists"));
		return;
	}
	if(! infoFile.open(QIODevice::WriteOnly))
	{
		QMessageBox::critical(this, tr("File error"), tr("Cannot open video information file"));
		return;
	}
	QTextStream	out(&infoFile);
	out << "ID:" << targetVideo->id
		<< "\nTitle:" << targetVideo->title 
		<< "\nDate:" << targetVideo->datetime;
	infoFile.close();
	
	videoFile = new QFile(downloadDir + targetVideo->id + videoFileExt);
	if(videoFile->exists())
	{
		QMessageBox::critical(this, tr("File error"), tr("File already exists."));
		return;
	}
	if(!videoFile->open(QIODevice::WriteOnly))
	{
		QMessageBox::critical(this, tr("File error"), tr("Cannot open video file"));
		return;
	}
	
	// 'GET' video file
	QUrl	url(targetVideo->url);
	connection->setHost(url.host(), url.port());
	qDebug() << "Host:" << url.host() << " Port:" << url.port() << " Path:" << url.path() + "?" + url.encodedQuery();
	downloadId = connection->get(url.path() + "?" + url.encodedQuery(), videoFile);

	// Create progress dialog
	progressDialog->findChild<QLabel*>("titleItem")->setText(targetVideo->title);
	progressDialog->findChild<QLabel*>("fileSizeItem")->setText(QString("%L1 bytes").arg(targetVideo->size.toULongLong()));
	progressDialog->findChild<QLabel*>("locationItem")->setText(videoFile->fileName());
	QProgressBar	*progressBar = progressDialog->findChild<QProgressBar*>("progressBar");
	progressBar->setMaximum(targetVideo->size.toInt());
	progressBar->setValue(0);
	
	progressDialog->show();
	progressTimer->start();
}

/*
	Progress dialog update by timer
*/
void	MainWindowImpl::progressUpdate()
{
	progressDialog->findChild<QProgressBar*>("progressBar")->setValue(videoFile->size());
}

/*
	Download cancel process
*/
void	MainWindowImpl::downloadCanceled()
{
	connection->abort();
	downloadQueue->clear();
	progressDialog->hide();
	if(videoFile->exists())
	{
		videoFile->close();
		videoFile->remove();
	}
	QMessageBox::information(this, tr("Canceled"), tr("Video file download canceled."));
}

//
