﻿#!/usr/bin/perl

#┌─────────────────────────────────
#│ wf_admin.cgi - 2006/08/03
#│ Copyright (c) KentWeb
#│ webmaster@kent-web.com
#│ http://www.kent-web.com/
#└─────────────────────────────────

# 外部ファイル取り込み
require './jcode.pl';
require './wf_init.cgi';

&decode;
if ($in{'pass'} eq "") { &enter; }
elsif ($mode eq "edit" && $in{'no'}) { &edit; }
elsif ($mode eq "edit2" && $in{'no'}) { &edit2; }
elsif ($mode eq "dele" && $in{'no'}) { &dele; }
&loglist;

#---------------------------------------
#  リスト画面
#---------------------------------------
sub loglist {
	if ($in{'pass'} ne $pass) { &ERR2("パスワードが違います"); }

	&HEADER;
	print <<EOM;
<form action="$script">
<input type="submit" value="掲示板に戻る"></form>
<ul>
<li>処理を選択して送信ボタンを押してください。
<li>ツリーの先頭記事を削除すると、ツリーごと一括削除されます。
</ul>
<form action="$admin" method="post">
<input type="hidden" name="pass" value="$in{'pass'}">
処理 <select name="mode">
<option value="edit">修正
<option value="dele">削除
</select>
<input type="submit" value="送信する">
<dl>
EOM

	local($i) = 0;
	local($x) = 0;
	open(IN,"$logfile") || &error("Open Error: $logfile");
	$top = <IN>;
	while (<IN>) {
		local($no,$re,$lx,$sub,$eml,$url,$nam,$dat,$msg,$t,$hos,$pw,$wr,$oya,$smail,$res,$setname) = split(/<>/);
		if ($re == 0) { $i++; }
		if ($i < $page + 1) { next; }
		if ($i > $page + $p_tree) { next; }

		if ($lx) { $sp="&nbsp;&nbsp;&nbsp;" x $lx; } else { $sp=""; }
		$msg =~ s/<br>/ /g;
		if (length($msg) > 60) { $msg = substr($msg,0,58); $msg .= '..'; }

		print "<dt>";
		print "<hr>" if ($no == $oya);
		print "$sp<input type=checkbox name=no value=\"$no\">[$no] <b>$sub</b> ";
		print "- <B>$nam</B> \[$setname\] $dat 【$hos】\n";
		print "<dd>$sp<span style='font-size:11px;color:$no_color;'>$msg</span>\n";

	}
	close(IN);

	print "<dt><hr></dl></form>\n";

	local($next) = $page + $p_tree;
	local($back) = $page - $p_tree;

	print "<table><tr>\n";
	if ($back >= 0) {
		print "<td><form action=\"$admin\" method=\"post\">\n";
		print "<input type=\"hidden\" name=\"pass\" value=\"$in{'pass'}\">\n";
		print "<input type=\"hidden\" name=\"page\" value=\"$back\">\n";
		print "<input type=\"submit\" value=\"前画面\"></form></td>\n";
	}
	if ($next < $i) {
		print "<td><form action=\"$admin\" method=\"post\">\n";
		print "<input type=\"hidden\" name=\"pass\" value=\"$in{'pass'}\">\n";
		print "<input type=\"hidden\" name=\"page\" value=\"$next\">\n";
		print "<input type=\"submit\" value=\"次画面\"></form></td>\n";
	}

	print <<EOM;
</tr>
</table>
EOM
	&FOOTER;
	exit;
}

#---------------------------------------
#  編集画面
#---------------------------------------
sub edit {
	local($top,$no,$re,$x,$sub,$eml,$url,$nam,$dat,$msg,$t,$ho,$pw,$wr,$oya,$sml);

	if ($in{'pass'} ne $pass) { &error("パスワードが違います"); }

	if ($in{'no'} =~ /\0/) { &error("修正処理は１記事づつです"); }

	# ログを開く
	open(IN,"$logfile") || &error("Can't open $logfile");
	$top = <IN>;
	while (<IN>) {
		($no,$re,$x,$sub,$eml,$url,$nam,$dat,$msg,$t,$ho,$pw,$wr,$oya,$sml) = split(/<>/);

		last if ($in{'no'} == $no);
	}
	close(IN);

	$msg =~ s/<br>/\n/g;

	# 編集フォームを出力
	&HEADER;
	print <<EOM;
<form>
<input type="button" value="前画面に戻る" onclick="history.back()">
</form>
▼変更したい部分のみ修正し送信ボタンを押してください。
<form action="$admin" method="post">
<input type="hidden" name="mode" value="edit2">
<input type="hidden" name="no" value="$in{'no'}">
<input type="hidden" name="pass" value="$in{'pass'}">
<table border="0">
<tr>
  <td><B>投稿者</B></td>
  <td><input type="text" name="name" value="$nam" size="28"></td>
</tr>
<tr>
  <td><B>Ｅメール</B></td>
  <td><input type="text" name="email" value="$eml" size="28">
	<select name="smail">
EOM

	@sm = ('表示', '非表示');
	foreach (0, 1) {
		if ($sml == $_) {
			print "<option value=\"$_\" selected>$sm[$_]\n";
		} else {
			print "<option value=\"$_\">$sm[$_]\n";
		}
	}

	print <<EOM;
</select></td>
</tr>
<tr>
  <td><B>タイトル</B></td>
  <td><input type="text" name="sub" value="$sub" size="38"></td>
</tr>
<tr>
  <td colspan="2"><B>メッセージ</B>
EOM

	@w1 = ('手動改行', '強制改行', '図表モード');
	@w2 = ('soft', 'hard', 'pre');
	foreach (0 .. 2) {
		if ($wr eq $w2[$_]) {
			print "<input type=\"radio\" name=\"wrap\" value=\"$w2[$_]\" checked>$w1[$_]\n";
		} else {
			print "<input type=\"radio\" name=\"wrap\" value=\"$w2[$_]\">$w1[$_]\n";
		}
	}

	print <<EOM;
<br><textarea name="message" cols="64" rows="10">$msg</textarea></td>
</tr>
<tr>
  <td><B>参照先</B></td>
  <td><input type="text" name="url" value="$url" size="55"></td>
</tr>
</table>
<p>
<input type="submit" value=" 送信する "><input type="reset" value="リセット">
</form>
EOM
	&FOOTER;
	exit;
}

#---------------------------------------
#  編集実行
#---------------------------------------
sub edit2 {
	# POST限定
	if ($postonly && !$post_flag) { &error("不正なアクセスです"); }

	if ($in{'pass'} ne $pass) { &error("パスワードが違います"); }

	# ロック開始
	&lock if ($lockkey);

	# ログを開く
	local($top,@new);
	open(IN,"$logfile") || &error("Open Error: $logfile");
	$top = <IN>;
	while (<IN>) {
		s/\n//;
		local($no,$re,$x,$sub,$eml,$url,$nam,$dat,$msg,$t,$ho,$pw,$wr,$oya,$sml,$res) = split(/<>/);
		if ($in{'no'} == $no) {
			$_ = "$no<>$re<>$x<>$in{'sub'}<>$in{'email'}<>$in{'url'}<>$in{'name'}<>$dat<>$in{'message'}<>$t<>$ho<>$pw<>$in{'wrap'}<>$oya<>$in{'smail'}<>$res<>";
		}
		push(@new,"$_\n");
	}
	close(IN);

	# ログを更新
	unshift(@new,$top);
	open(OUT,">$logfile") || &error("Write Error: $logfile");
	print OUT @new;
	close(OUT);

	# ロック解除
	&unlock if ($lockkey);

	# 初期画面に戻る
	&loglist;
}

#---------------------------------------
#  削除処理
#---------------------------------------
sub dele {
	# POST限定
	if ($postonly && !$post_flag) { &error("不正なアクセスです"); }

	if ($in{'pass'} ne $pass) { &error("パスワードが違います"); }

	# ロック開始
	&lock if ($lockkey);

	# ログを開く
	local($flag,$top,@new);
	open(IN,"$logfile") || &error("Open Error: $logfile");
	$top = <IN>;
	while (<IN>) {
		$flag = 0;
		($no,$re,$x,$sub,$eml,$url,$nam,$dat,$msg,$t,$ho,$pw,$wr,$oya) = split(/<>/);

		# マッチング
		foreach $del ( split(/\0/, $in{'no'}) ) {
			if ($del == $no || $del == $oya) {
				$flag = 1;
				last;
			}
		}
		if (!$flag) { push(@new,$_); }
	}
	close(IN);

	# ログを更新
	unshift(@new,$top);
	open(OUT,">$logfile") || &error("Write Error: $logfile");
	print OUT @new;
	close(OUT);

	# ロック解除
	&unlock if ($lockkey);

	# 初期画面に戻る
	&loglist;
}

#---------------------------------------
#  入室画面
#---------------------------------------
sub enter {
	&header;
	print <<EOM;
<div align="center">
<h4>パスワードを入力してください</h4>
<form action="$admin" method="post">
<input type="password" name="pass" size="8">
<input type="submit" value=" 認証 "></form>
</div>
<!-- $ver -->
EOM
	&FOOTER;
	exit;
}

